/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.internal;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Conditional(value={SelfTracingCondition.class})
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface ConditionalOnSelfTracing {
    public String storageType() default "";

    public static class SelfTracingCondition
    extends SpringBootCondition {
        static final boolean BRAVE_PRESENT = SelfTracingCondition.checkForBrave();

        static boolean checkForBrave() {
            try {
                Class.forName("brave.Tracing");
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata a) {
            if (!BRAVE_PRESENT) {
                return ConditionOutcome.noMatch((String)"Brave must be in the classpath");
            }
            String selfTracingEnabled = context.getEnvironment().getProperty("zipkin.self-tracing.enabled");
            if (!Boolean.valueOf(selfTracingEnabled).booleanValue()) {
                return ConditionOutcome.noMatch((String)"zipkin.self-tracing.enabled isn't true");
            }
            String expectedStorageType = AnnotationAttributes.fromMap((Map)a.getAnnotationAttributes(ConditionalOnSelfTracing.class.getName())).getString("storageType");
            if (expectedStorageType.equals("")) {
                return ConditionOutcome.match();
            }
            String storageType = context.getEnvironment().getProperty("zipkin.storage.type");
            return expectedStorageType.equals(storageType) ? ConditionOutcome.match() : ConditionOutcome.noMatch((String)("zipkin.storage.type was: " + storageType + " expected " + expectedStorageType));
        }
    }
}

