/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.internal;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import zipkin.Codec;
import zipkin.internal.Util;
import zipkin.internal.V2StorageComponent;
import zipkin.storage.QueryRequest;
import zipkin2.storage.StorageComponent;

@RestController
@RequestMapping(value={"/api/v1"})
@ConditionalOnProperty(name={"zipkin.query.enabled"}, matchIfMissing=true)
public class ZipkinQueryApiV1 {
    @Autowired
    @Value(value="${zipkin.query.lookback:86400000}")
    int defaultLookback = 86400000;
    @Value(value="${zipkin.query.names-max-age:300}")
    int namesMaxAge = 300;
    volatile int serviceCount;
    private final zipkin.storage.StorageComponent storage;

    @Autowired
    public ZipkinQueryApiV1(StorageComponent storage) {
        this.storage = V2StorageComponent.create((StorageComponent)storage);
    }

    @RequestMapping(value={"/dependencies"}, method={RequestMethod.GET}, produces={"application/json"})
    public byte[] getDependencies(@RequestParam(value="endTs", required=true) long endTs, @RequestParam(value="lookback", required=false) Long lookback) {
        return Codec.JSON.writeDependencyLinks(this.storage.spanStore().getDependencies(endTs, Long.valueOf(lookback != null ? lookback : (long)this.defaultLookback)));
    }

    @RequestMapping(value={"/services"}, method={RequestMethod.GET})
    public ResponseEntity<List<String>> getServiceNames() {
        List serviceNames = this.storage.spanStore().getServiceNames();
        this.serviceCount = serviceNames.size();
        return this.maybeCacheNames(serviceNames);
    }

    @RequestMapping(value={"/spans"}, method={RequestMethod.GET})
    public ResponseEntity<List<String>> getSpanNames(@RequestParam(value="serviceName", required=true) String serviceName) {
        return this.maybeCacheNames(this.storage.spanStore().getSpanNames(serviceName));
    }

    @RequestMapping(value={"/traces"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getTraces(@RequestParam(value="serviceName", required=false) String serviceName, @RequestParam(value="spanName", defaultValue="all") String spanName, @RequestParam(value="annotationQuery", required=false) String annotationQuery, @RequestParam(value="minDuration", required=false) Long minDuration, @RequestParam(value="maxDuration", required=false) Long maxDuration, @RequestParam(value="endTs", required=false) Long endTs, @RequestParam(value="lookback", required=false) Long lookback, @RequestParam(value="limit", required=false) Integer limit) {
        QueryRequest queryRequest = QueryRequest.builder().serviceName(serviceName).spanName(spanName).parseAnnotationQuery(annotationQuery).minDuration(minDuration).maxDuration(maxDuration).endTs(endTs).lookback(Long.valueOf(lookback != null ? lookback : (long)this.defaultLookback)).limit(limit).build();
        return new String(Codec.JSON.writeTraces(this.storage.spanStore().getTraces(queryRequest)), Util.UTF_8);
    }

    @RequestMapping(value={"/trace/{traceIdHex}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getTrace(@PathVariable String traceIdHex, WebRequest request) {
        List trace;
        long traceIdHigh = traceIdHex.length() == 32 ? Util.lowerHexToUnsignedLong((String)traceIdHex, (int)0) : 0L;
        long traceIdLow = Util.lowerHexToUnsignedLong((String)traceIdHex);
        String[] raw = request.getParameterValues("raw");
        List list = trace = raw != null ? this.storage.spanStore().getRawTrace(traceIdHigh, traceIdLow) : this.storage.spanStore().getTrace(traceIdHigh, traceIdLow);
        if (trace == null) {
            throw new TraceNotFoundException(traceIdHex, traceIdHigh, traceIdLow);
        }
        return new String(Codec.JSON.writeSpans(trace), Util.UTF_8);
    }

    @ExceptionHandler(value={TraceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void notFound() {
    }

    ResponseEntity<List<String>> maybeCacheNames(List<String> names) {
        ResponseEntity.BodyBuilder response = ResponseEntity.ok();
        if (this.serviceCount > 3) {
            response.cacheControl(CacheControl.maxAge((long)this.namesMaxAge, (TimeUnit)TimeUnit.SECONDS).mustRevalidate());
        }
        return response.body(names);
    }

    static class TraceNotFoundException
    extends RuntimeException {
        public TraceNotFoundException(String traceIdHex, Long traceIdHigh, long traceId) {
            super(String.format("Cannot find trace for id=%s,  parsed value=%s", traceIdHex, traceIdHigh != null ? traceIdHigh + "," + traceId : Long.valueOf(traceId)));
        }
    }
}

