/**
 *
 * Copyright 2003-2004 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

//
// This source code implements specifications defined by the Java
// Community Process. In order to remain compliant with the specification
// DO NOT add / change / or delete method signatures!
//

package javax.servlet.http;

/**
 * This is the class representing event notifications for
 * changes to sessions within a web application.
 * @since Servlet 2.3
 *
 * @version $Rev: 46019 $ $Date: 2004-09-14 04:56:06 -0500 (Tue, 14 Sep 2004) $
 */
public class HttpSessionEvent extends java.util.EventObject {
    /**
     * Construct a session event from the given source.
     */
    public HttpSessionEvent(HttpSession source) {
        super(source);
    }

    /**
     * Return the session that changed.
     */
    public HttpSession getSession() {
        return (HttpSession) super.getSource();
    }
}

