/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel;

import edu.npu.fastexcel.ExcelException;
import edu.npu.fastexcel.ReadableSheet;
import edu.npu.fastexcel.Sheet;
import edu.npu.fastexcel.SheetReadListener;
import edu.npu.fastexcel.Workbook;
import edu.npu.fastexcel.biff.parser.ParserException;
import edu.npu.fastexcel.biff.parser.globals.Format;
import edu.npu.fastexcel.biff.read.BIFFReader;
import edu.npu.fastexcel.biff.read.DefaultSheetStream;
import edu.npu.fastexcel.biff.read.EventBasedSheetStream;
import edu.npu.fastexcel.biff.read.SheetStream;
import edu.npu.fastexcel.biff.read.WorkBookGlobalsStream;
import edu.npu.fastexcel.compound.io.ReadException;
import java.io.File;
import java.text.SimpleDateFormat;

class ReadableWorkbook
implements Workbook {
    private File file;
    private BIFFReader biffReader;
    private WorkBookGlobalsStream globalsStream;

    public ReadableWorkbook(File file) {
        this.file = file;
        this.biffReader = new BIFFReader(file);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
        this.biffReader.setFile(file);
    }

    @Override
    public void open() throws ExcelException {
        try {
            this.biffReader.open();
            this.biffReader.readWorkBookGlobals();
            this.globalsStream = (WorkBookGlobalsStream)this.biffReader.getWorkBookStream().getSubStream("WORKBOOK_GLOBALS");
        }
        catch (ReadException e) {
            throw new ExcelException(e);
        }
        catch (ParserException e) {
            throw new ExcelException(e);
        }
    }

    @Override
    public Format getFormat(int index) throws ExcelException {
        if (this.globalsStream == null) {
            throw new ExcelException("Workbook did not open.Invoke open() first");
        }
        return this.globalsStream.getFormat(index);
    }

    @Override
    public void addUserDefineFormat(int index, int type, String formatStr) throws ExcelException {
        if (this.globalsStream == null) {
            throw new ExcelException("Workbook did not open.Invoke open() first");
        }
        if (index < 0) {
            throw new IllegalArgumentException("Format index must >=0");
        }
        this.globalsStream.addFormat(index, type, formatStr);
    }

    @Override
    public void close() throws ExcelException {
        try {
            this.biffReader.close();
        }
        catch (ReadException e) {
            throw new ExcelException(e);
        }
    }

    @Override
    public int sheetCount() {
        return this.globalsStream == null ? 0 : this.globalsStream.sheetCount();
    }

    @Override
    public String[] sheetNames() {
        return this.globalsStream.sheetNames();
    }

    @Override
    public void getSheet(int index, SheetReadListener l) throws ExcelException {
        if (index < 0 || index >= this.globalsStream.sheetCount()) {
            throw new ExcelException("can not find this sheet,index=" + index);
        }
        if (this.globalsStream == null) {
            throw new ExcelException("Workbook did not open.Invoke open() first");
        }
        EventBasedSheetStream ss = new EventBasedSheetStream(this.globalsStream.getSheetStream(index), this.globalsStream);
        ss.setListener(l);
        try {
            this.biffReader.readSheet(ss);
        }
        catch (ReadException e) {
            throw new ExcelException(e);
        }
    }

    @Override
    public void getSheet(String name, SheetReadListener l) throws ExcelException {
        if (this.globalsStream == null) {
            throw new ExcelException("Workbook did not open.Invoke open() first");
        }
        SheetStream sheetStream = this.globalsStream.getSheetStream(name);
        if (sheetStream == null) {
            throw new ExcelException("can not find this sheet,name=" + name);
        }
        EventBasedSheetStream ss = new EventBasedSheetStream(sheetStream, this.globalsStream);
        ss.setListener(l);
        try {
            this.biffReader.readSheet(ss);
        }
        catch (ReadException e) {
            throw new ExcelException(e);
        }
    }

    @Override
    public Sheet getSheet(int index) throws ExcelException {
        if (index < 0 || index >= this.globalsStream.sheetCount()) {
            throw new ExcelException("can not find this sheet,index=" + index);
        }
        if (this.globalsStream == null) {
            throw new ExcelException("Workbook did not open.Invoke open() first");
        }
        SheetStream sheetStream = this.globalsStream.getSheetStream(index);
        if (sheetStream == null) {
            throw new ExcelException("can not find this sheet,index=" + index);
        }
        DefaultSheetStream ss = new DefaultSheetStream(sheetStream, this.globalsStream);
        try {
            this.biffReader.readSheet(ss);
        }
        catch (ReadException e) {
            throw new ExcelException(e);
        }
        return new ReadableSheet(ss);
    }

    @Override
    public Sheet getSheet(String name) throws ExcelException {
        if (this.globalsStream == null) {
            throw new ExcelException("Workbook did not open.Invoke open() first");
        }
        SheetStream sheetStream = this.globalsStream.getSheetStream(name);
        if (sheetStream == null) {
            throw new ExcelException("can not find this sheet,name=" + name);
        }
        DefaultSheetStream stream = new DefaultSheetStream(sheetStream, this.globalsStream);
        try {
            this.biffReader.readSheet(stream);
        }
        catch (ReadException e) {
            throw new ExcelException(e);
        }
        return new ReadableSheet(stream);
    }

    @Override
    public void enableFormatNumber() {
        this.biffReader.getSetting().setFormatNumber(true);
    }

    @Override
    public void disableFormatNumber() {
        this.biffReader.getSetting().setFormatNumber(false);
    }

    @Override
    public void enableFormatDate() {
        this.biffReader.getSetting().setFormatDate(true);
    }

    @Override
    public void disableFormatDate() {
        this.biffReader.getSetting().setFormatDate(false);
    }

    @Override
    public void enableCommonDateFormat() {
        this.biffReader.getSetting().setCommonDateFormat(true);
    }

    @Override
    public void disableCommonDateFormat() {
        this.biffReader.getSetting().setCommonDateFormat(false);
    }

    @Override
    public void setCommonDateFormat(SimpleDateFormat dateFormat) {
        this.biffReader.getSetting().setDateFormat(dateFormat);
    }

    @Override
    public Sheet addSheet(String name) {
        throw new IllegalStateException("Readable Workbook can not add sheet.");
    }

    @Override
    public Sheet addStreamSheet(String name) throws ExcelException {
        throw new IllegalStateException("Readable Workbook can not add sheet.");
    }

    @Override
    public void setSSTType(int type) {
        this.biffReader.getSetting().setSSTType(type);
    }
}

