/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel;

import edu.npu.fastexcel.ExcelException;
import edu.npu.fastexcel.Sheet;
import edu.npu.fastexcel.biff.write.SheetWriter;
import edu.npu.fastexcel.compound.io.WriteException;

public class WritableSheet
implements Sheet {
    SheetWriter sheetStreamWriter;

    WritableSheet(SheetWriter writer) {
        this.sheetStreamWriter = writer;
    }

    @Override
    public int getFirstColumn() {
        return this.sheetStreamWriter.getDimension().firstCol;
    }

    @Override
    public int getFirstRow() {
        return this.sheetStreamWriter.getDimension().firstRow;
    }

    @Override
    public int getIndex() {
        return this.sheetStreamWriter.getIndex();
    }

    @Override
    public int getLastColumn() {
        return this.sheetStreamWriter.getDimension().lastCol;
    }

    @Override
    public int getLastRow() {
        return this.sheetStreamWriter.getDimension().lastRow;
    }

    @Override
    public String getName() {
        return this.sheetStreamWriter.getName();
    }

    @Override
    public String[] getRow(int row) {
        throw new IllegalStateException("Writable Sheet can not getRow");
    }

    @Override
    public String getCell(int row, int col) {
        throw new IllegalStateException("Writable Sheet can not getCell");
    }

    @Override
    public void setCell(int row, int col, String str) throws ExcelException {
        try {
            this.sheetStreamWriter.setCell(row, col, str);
        }
        catch (WriteException e) {
            throw new ExcelException(e);
        }
    }

    @Override
    public void setRow(int row, String[] s) throws ExcelException {
        if (s == null) {
            return;
        }
        try {
            for (int i = 0; i < s.length; ++i) {
                this.sheetStreamWriter.setCell(row, i, s[i]);
            }
        }
        catch (WriteException e) {
            throw new ExcelException(e);
        }
    }

    @Override
    public void addRow(String[] s) throws ExcelException {
        if (s == null) {
            return;
        }
        try {
            this.sheetStreamWriter.addRow(s);
        }
        catch (WriteException e) {
            throw new ExcelException(e);
        }
    }

    @Override
    public short getFirstColIndex(int row) throws ExcelException {
        throw new IllegalStateException("Writable Sheet can not getFirstColIndex");
    }

    @Override
    public short getLastColIndex(int row) throws ExcelException {
        throw new IllegalStateException("Writable Sheet can not getLastColIndex");
    }
}

