/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel;

import edu.npu.fastexcel.ExcelException;
import edu.npu.fastexcel.Sheet;
import edu.npu.fastexcel.SheetReadListener;
import edu.npu.fastexcel.Workbook;
import edu.npu.fastexcel.WritableSheet;
import edu.npu.fastexcel.biff.parser.globals.Format;
import edu.npu.fastexcel.biff.write.BIFFWriter;
import edu.npu.fastexcel.biff.write.SheetWriter;
import edu.npu.fastexcel.biff.write.WorkBookGlobalsStreamWriter;
import edu.npu.fastexcel.compound.io.WriteException;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

class WritableWorkbook
implements Workbook {
    private File file;
    private BIFFWriter biffWriter;
    WorkBookGlobalsStreamWriter workbookGlobalsStreamWriter;

    public WritableWorkbook(File file) {
        this.file = file;
        this.biffWriter = new BIFFWriter(file);
    }

    @Override
    public Sheet addStreamSheet(String name) throws ExcelException {
        SheetWriter ssw;
        if (this.workbookGlobalsStreamWriter == null) {
            throw new IllegalStateException("Open Workbook first.");
        }
        try {
            ssw = this.workbookGlobalsStreamWriter.addSheet(name, true);
        }
        catch (WriteException e) {
            throw new ExcelException(e);
        }
        return new WritableSheet(ssw);
    }

    @Override
    public Sheet addSheet(String name) throws ExcelException {
        SheetWriter ssw;
        if (this.workbookGlobalsStreamWriter == null) {
            throw new IllegalStateException("Open Workbook first.");
        }
        try {
            ssw = this.workbookGlobalsStreamWriter.addSheet(name, false);
        }
        catch (WriteException e) {
            throw new ExcelException(e);
        }
        return new WritableSheet(ssw);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
        this.biffWriter.setFile(file);
    }

    @Override
    public void open() throws ExcelException {
        if (this.workbookGlobalsStreamWriter != null) {
            throw new IllegalStateException("Workbook already opened.");
        }
        try {
            this.workbookGlobalsStreamWriter = this.biffWriter.open();
        }
        catch (WriteException e) {
            throw new ExcelException(e);
        }
    }

    @Override
    public void close() throws ExcelException {
        if (this.workbookGlobalsStreamWriter == null) {
            throw new IllegalStateException("Open Workbook first.");
        }
        try {
            this.biffWriter.close();
        }
        catch (WriteException e) {
            throw new ExcelException(e);
        }
    }

    @Override
    public int sheetCount() {
        if (this.workbookGlobalsStreamWriter != null) {
            throw new IllegalStateException("Open Workbook first.");
        }
        return this.biffWriter.getWorkbookGlobalsStreamWriter().getSheetStreamWriters().size();
    }

    @Override
    public String[] sheetNames() {
        if (this.workbookGlobalsStreamWriter != null) {
            throw new IllegalStateException("Open Workbook first.");
        }
        ArrayList<SheetWriter> l = this.biffWriter.getWorkbookGlobalsStreamWriter().getSheetStreamWriters();
        String[] names = new String[l.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((SheetWriter)l.get(i)).getName();
        }
        return names;
    }

    @Override
    public void getSheet(int index, SheetReadListener l) throws ExcelException {
        throw new IllegalStateException("Writable Workbook can not getSheet.");
    }

    @Override
    public void getSheet(String name, SheetReadListener l) throws ExcelException {
        throw new IllegalStateException("Writable Workbook can not getSheet.");
    }

    @Override
    public Sheet getSheet(int index) throws ExcelException {
        throw new IllegalStateException("Writable Workbook can not getSheet.");
    }

    @Override
    public Sheet getSheet(String name) throws ExcelException {
        throw new IllegalStateException("Writable Workbook can not getSheet.");
    }

    @Override
    public void enableFormatNumber() {
        throw new IllegalStateException("Writable Workbook can not enableFormatNumber.");
    }

    @Override
    public void disableFormatNumber() {
        throw new IllegalStateException("Writable Workbook can not disableFormatNumber.");
    }

    @Override
    public void enableFormatDate() {
        throw new IllegalStateException("Writeable Workbook can not enableFormatDate.");
    }

    @Override
    public void disableFormatDate() {
        throw new IllegalStateException("Writable Workbook can not disableFormatDate.");
    }

    @Override
    public void enableCommonDateFormat() {
        throw new IllegalStateException("Writable Workbook can not enableCommonDateFormat.");
    }

    @Override
    public void disableCommonDateFormat() {
        throw new IllegalStateException("Writable Workbook can not disableCommonDateFormat.");
    }

    @Override
    public void setCommonDateFormat(SimpleDateFormat dateFormat) {
        throw new IllegalStateException("Writable Workbook can not setCommonDateFormat.");
    }

    @Override
    public void addUserDefineFormat(int index, int type, String formatStr) throws ExcelException {
        throw new IllegalStateException("Writable Workbook can not addUserDefineFormat.");
    }

    @Override
    public Format getFormat(int index) throws ExcelException {
        throw new IllegalStateException("Writable Workbook can not getFormat.");
    }

    @Override
    public void setSSTType(int type) {
        throw new IllegalStateException("Writable Workbook can not set sst type.");
    }
}

