/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.parser;

import edu.npu.fastexcel.biff.parser.ParserContext;
import edu.npu.fastexcel.biff.parser.ParserException;
import edu.npu.fastexcel.biff.parser.RecordParser;
import edu.npu.fastexcel.biff.record.Record;
import edu.npu.fastexcel.common.util.NumUtil;

public class BOFParser
extends RecordParser {
    public static final int BIFF_VERSION_5 = 1280;
    public static final int BIFF_VERSION_8 = 1536;
    public static final int BIFF_VERSION_8X = 1536;
    public static final int BIFF_TYPE_WORKBOOK_GLOBALS = 5;
    public static final int BIFF_TYPE_VB = 6;
    public static final int BIFF_TYPE_SHEET_OR_DIALOGUE = 16;
    public static final int BIFF_TYPE_CHART = 32;
    public static final int BIFF_TYPE_MARCO_SHEET = 64;
    public static final int BIFF_TYPE_WORKSPACE = 256;

    public BOFParser() {
        super(2057);
    }

    @Override
    public void parse(Record record, ParserContext c) throws ParserException {
        int off;
        byte[] b = record.getBytes();
        int version = NumUtil.getInt(b[off = 4], b[off + 1]);
        if (version != 1536) {
            throw new ParserException("wrong BIFF version.");
        }
        int type = NumUtil.getInt(b[off + 2], b[off + 3]);
        if (type == 5) {
            c.getStream().getCurrentStream().setVersion(version);
        } else if (type == 16) {
            c.getStream().getCurrentStream().setVersion(version);
        }
    }
}

