/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.parser.cell;

import edu.npu.fastexcel.biff.parser.ParserException;
import edu.npu.fastexcel.biff.parser.cell.CellParser;
import edu.npu.fastexcel.biff.parser.globals.Format;
import edu.npu.fastexcel.biff.parser.globals.XF;
import edu.npu.fastexcel.biff.read.RecordReader;
import edu.npu.fastexcel.biff.record.ReadOnlyRecord;
import edu.npu.fastexcel.common.util.NumUtil;
import edu.npu.fastexcel.common.util.StringUtil;
import edu.npu.fastexcel.compound.io.ReadException;
import java.text.DecimalFormat;

public class FormulaParser
extends CellParser {
    private static DecimalFormat decimalFormat = new DecimalFormat("#.##############");

    public FormulaParser() {
        super(1030);
    }

    protected FormulaParser(int type) {
        super(type);
    }

    @Override
    public void parse() throws ParserException {
        if (this.b[this.off + 6] == 0 && this.b[this.off + 12] == -1 && this.b[this.off + 13] == -1) {
            this.parseStringFormula();
        } else if (this.b[this.off + 6] == 1 && this.b[this.off + 12] == -1 && this.b[this.off + 13] == -1) {
            this.parseBooleanFormula();
        } else if (this.b[this.off + 6] == 2 && this.b[this.off + 12] == -1 && this.b[this.off + 13] == -1) {
            this.parseErrorFormula();
        } else if (this.b[this.off + 6] == 3 && this.b[this.off + 12] == -1 && this.b[this.off + 13] == -1) {
            this.parseEmptyStringFormula();
        } else {
            this.parseNumberFormula();
        }
    }

    protected void parseNumberFormula() {
        Format f;
        XF x;
        double value = NumUtil.getIEEEDouble(this.b, this.off + 6);
        String sValue = Double.toString(value);
        int i = sValue.indexOf(46) + 1;
        if (sValue.length() - i == 15) {
            value = Double.valueOf(decimalFormat.format(value));
        }
        if ((x = this.workBookGlobalsStream.getXF(this.xf)) != null && (f = this.workBookGlobalsStream.getFormat(x.getFormat())) != null) {
            String str = f.format(new Double(value), this.workBookGlobalsStream, this.context.getSetting());
            this.sheetStream.setContent(this.r, this.c, str);
            return;
        }
        this.sheetStream.setContent(this.r, this.c, value + "");
    }

    protected void parseBooleanFormula() {
        boolean value = this.b[this.off + 8] == 1;
        this.sheetStream.setContent(this.r, this.c, value + "");
    }

    protected void parseErrorFormula() {
        byte errorCode = this.b[this.off + 4];
        this.sheetStream.setContent(this.r, this.c, "ERROR" + errorCode);
    }

    protected void parseEmptyStringFormula() {
        this.sheetStream.setContent(this.r, this.c, "");
    }

    protected void parseStringFormula() {
        ReadOnlyRecord nextRecord = new ReadOnlyRecord();
        RecordReader recordReader = this.context.getStreamReader();
        try {
            for (int count = 1; recordReader.nextRecord(nextRecord) && nextRecord.getType() != 519 && count < 4; ++count) {
            }
        }
        catch (ReadException readException) {
            // empty catch block
        }
        int len = nextRecord.getContentLength();
        byte[] stringData = new byte[len];
        System.arraycopy(nextRecord.getBytes(), this.off, stringData, 0, len);
        String value = this.buildString(stringData);
        this.sheetStream.setContent(this.r, this.c, value);
    }

    private String buildString(byte[] d) {
        boolean richString;
        int pos = 0;
        int chars = NumUtil.getInt(d[0], d[1]);
        if (chars == 0) {
            String value = "";
            return value;
        }
        byte optionFlags = d[pos += 2];
        ++pos;
        if ((optionFlags & 0xF) != optionFlags) {
            pos = 0;
            chars = NumUtil.getInt(d[0], (byte)0);
            optionFlags = d[1];
            pos = 2;
        }
        boolean extendedString = (optionFlags & 4) != 0;
        boolean bl = richString = (optionFlags & 8) != 0;
        if (richString) {
            pos += 2;
        }
        if (extendedString) {
            pos += 4;
        }
        boolean asciiEncoding = (optionFlags & 1) == 0;
        String value = asciiEncoding ? StringUtil.getASCIIString(d, pos, chars) : StringUtil.getUnicodeString(d, pos, chars);
        return value;
    }
}

