/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.parser.globals;

import edu.npu.fastexcel.biff.parser.globals.Format;
import java.util.HashMap;

public class BuiltinFormats {
    private static HashMap<String, Format> formatMap = new HashMap(64);
    private static final String CHINESE_YEAR = "\u5e74";
    private static final String CHINESE_MONTH = "\u6708";
    private static final String CHINESE_DAY = "\u65e5";
    private static final String CHINESE_HOUR = "\u65f6";
    private static final String CHINESE_MINUTE = "\u5206";
    private static final String CHINESE_SECOND = "\u79d2";

    private BuiltinFormats() {
    }

    public static Format getFormat(int index) {
        return formatMap.get(index + "");
    }

    static {
        formatMap.put("0", new Format(0, 3, "0"));
        formatMap.put("1", new Format(1, 4, "0"));
        formatMap.put("2", new Format(2, 4, "0.00"));
        formatMap.put("3", new Format(3, 4, "#,##0"));
        formatMap.put("4", new Format(4, 4, "#,##0.00"));
        formatMap.put("531", new Format(531, 5, "\"$\"#,##0_);(\"$\"#,##0)"));
        formatMap.put("631", new Format(631, 5, "\"$\"#,##0_);[Red](\"$\"#,##0)"));
        formatMap.put("731", new Format(731, 5, "\"$\"#,##0.00_);(\"$\"#,##0.00)"));
        formatMap.put("831", new Format(831, 5, "\"$\"#,##0.00_);[Red](\"$\"#,##0.00)"));
        formatMap.put("9", new Format(9, 11, "0%"));
        formatMap.put("10", new Format(10, 11, "0.00%"));
        formatMap.put("11", new Format(11, 6, "0.00E+00"));
        formatMap.put("12", new Format(12, 7, "# ?/?"));
        formatMap.put("13", new Format(13, 7, "# ??/??"));
        formatMap.put("14", new Format(14, 1, "yyyy-MM-dd"));
        formatMap.put("1432", new Format(1432, 1, "M/D/YY"));
        formatMap.put("15", new Format(15, 1, "D-MMM-YY"));
        formatMap.put("16", new Format(16, 1, "D-MMM"));
        formatMap.put("17", new Format(17, 1, "MMM-YY"));
        formatMap.put("18", new Format(18, 2, "h:mm AM/PM"));
        formatMap.put("19", new Format(19, 2, "h:mm:ss AM/PM"));
        formatMap.put("20", new Format(20, 2, "h:mm"));
        formatMap.put("21", new Format(21, 2, "h:mm:ss"));
        formatMap.put("22", new Format(22, 8, "yyyy-M-d HH:mm"));
        formatMap.put("2232", new Format(2232, 8, "M/D/YY h:mm"));
        formatMap.put("37", new Format(37, 9, "_(#,##0_);(#,##0)"));
        formatMap.put("38", new Format(38, 9, "_(#,##0_);[Red](#,##0)"));
        formatMap.put("39", new Format(39, 9, "_(#,##0.00_);(#,##0.00)"));
        formatMap.put("40", new Format(40, 9, "_(#,##0.00_);[Red](#,##0.00)"));
        formatMap.put("4131", new Format(4131, 5, "_(\"$\"* #,##0_);_(\"$\"* (#,##0);_(\"$\"* \"-\"_);_(@_)"));
        formatMap.put("423133", new Format(423133, 5, "_(* #,##0_);_(* (#,##0);_(* \"-\"_);_(@_)"));
        formatMap.put("4331", new Format(4331, 5, "_(\"$\"* #,##0.00_);_(\"$\"* (#,##0.00);_(\"$\"* \"-\"??_);_(@_)"));
        formatMap.put("443133", new Format(443133, 5, "_(* #,##0.00_);_(* (#,##0.00);_(* \"-\"??_);_(@_)"));
        formatMap.put("45", new Format(45, 2, "mm:ss"));
        formatMap.put("46", new Format(46, 2, "[h]:mm:ss"));
        formatMap.put("47", new Format(47, 2, "mm:ss.0"));
        formatMap.put("48", new Format(48, 6, "##0.0E+0"));
        formatMap.put("49", new Format(49, 3, "@"));
        formatMap.put("27", new Format(27, 1, "[$-0411]GE.M.d"));
        formatMap.put("28", new Format(28, 1, "[$-0411]yyyy\u5e74M\u6708d"));
        formatMap.put("29", new Format(29, 1, "[$-0411]yyyy\u5e74M\u6708d\u65e5"));
        formatMap.put("30", new Format(30, 1, "[$-0411]M/d/yy"));
        formatMap.put("31", new Format(31, 1, "[$-0411]yyyy\u5e74M\u6708d\u65e5"));
        formatMap.put("32", new Format(32, 2, "[$-0411]h\u65f6mm\u5206"));
        formatMap.put("33", new Format(33, 2, "[$-0411]h\"\u65f6\"mm\"\u5206\"ss\"\u79d2\""));
        formatMap.put("34", new Format(34, 1, "[$-0411]yyyy\u5e74M\u6708"));
        formatMap.put("35", new Format(35, 1, "[$-0411]M\u6708d\u65e5"));
        formatMap.put("36", new Format(36, 1, "[$-0411]yyyy.M.d"));
        formatMap.put("50", new Format(50, 1, "[$-0411]yyyy.M.d"));
        formatMap.put("51", new Format(51, 1, "[$-0411]\u5e74M\u6708d\u65e5"));
        formatMap.put("52", new Format(52, 1, "[$-0411]yyyy\u5e74M\u6708"));
        formatMap.put("53", new Format(53, 1, "[$-0411]M\u6708d\u65e5"));
        formatMap.put("54", new Format(54, 1, "[$-0411]yyyy\u5e74M\u6708d\u65e5"));
        formatMap.put("55", new Format(55, 1, "[$-0411]yyyy\u5e74M\u6708"));
        formatMap.put("56", new Format(56, 1, "[$-0411]m\u6708d\u65e5"));
        formatMap.put("57", new Format(57, 1, "[$-0411]yyyy\u5e74M\u6708"));
        formatMap.put("58", new Format(58, 1, "[$-0411]M\u6708d\u65e5"));
    }
}

