/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.parser.globals;

import edu.npu.fastexcel.BIFFSetting;
import edu.npu.fastexcel.biff.read.WorkBookGlobalsStream;
import edu.npu.fastexcel.common.util.DateUtil;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Format {
    private static final TimeZone GMTZONE = TimeZone.getTimeZone("GMT");
    public static final int TYPE_DATE = 1;
    public static final int TYPE_TIME = 2;
    public static final int TYPE_GENERAL = 3;
    public static final int TYPE_DECIMAL = 4;
    public static final int TYPE_CURRENCY = 5;
    public static final int TYPE_SCIENTIFIC = 6;
    public static final int TYPE_FRACTION = 7;
    public static final int TYPE_DATE_TIME = 8;
    public static final int TYPE_ACCOUNT = 9;
    public static final int TYPE_TEXT = 10;
    public static final int TYPE_PERCENT = 11;
    public static final String[] TIME_STRINGS = new String[]{"AM", "PM", "M", "S", "H", "am", "pm", "m", "s", "h"};
    public static final String[] DATE_STRINGS = new String[]{"M", "Y", "D", "m", "y", "d"};
    private int index;
    private int type;
    private String content;
    java.text.Format format;

    public Format(int index, int type, String content) {
        this.index = index;
        this.type = type;
        this.content = content;
    }

    public String format(Object value, WorkBookGlobalsStream gloablStream, BIFFSetting setting) {
        String str = value.toString();
        switch (this.type) {
            case 3: 
            case 7: {
                str = this.floatFormat(new Double(str));
                if (!str.endsWith(".0")) break;
                str = str.substring(0, str.length() - 2);
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                double time = (Double)value;
                str = this.getDate(time, gloablStream, setting);
                break;
            }
            default: {
                double number = (Double)value;
                str = this.getNumber(number, gloablStream, setting);
            }
        }
        return str;
    }

    private String getNumber(double value, WorkBookGlobalsStream gloablStream, BIFFSetting setting) {
        if (setting.isFormatNumber()) {
            return this.getNumberFormat().format(value);
        }
        return value + "";
    }

    private String getDate(double value, WorkBookGlobalsStream gloablStream, BIFFSetting setting) {
        long utcValue = DateUtil.getTimeMillis(value, gloablStream.getDateMode());
        if (!setting.isFormatDate()) {
            return utcValue + "";
        }
        if (setting.isCommonDateFormat()) {
            this.format = setting.getDateFormat();
            ((SimpleDateFormat)this.format).setTimeZone(GMTZONE);
        } else {
            this.format = this.getDateFormat();
            ((SimpleDateFormat)this.format).setTimeZone(GMTZONE);
        }
        Date date = new Date(utcValue);
        return this.format.format(date);
    }

    private static final String replace(String input, String search, String replace) {
        String fmtstr = input;
        int pos = fmtstr.indexOf(search);
        while (pos != -1) {
            StringBuffer tmp = new StringBuffer(fmtstr.substring(0, pos));
            tmp.append(replace);
            tmp.append(fmtstr.substring(pos + search.length()));
            fmtstr = tmp.toString();
            pos = fmtstr.indexOf(search);
        }
        return fmtstr;
    }

    public final NumberFormat getNumberFormat() {
        String formatString = this.content;
        if (this.format != null && this.format instanceof NumberFormat) {
            return (NumberFormat)this.format;
        }
        try {
            String fs = formatString;
            fs = Format.replace(fs, "E+", "E");
            fs = Format.replace(fs, "_)", "");
            fs = Format.replace(fs, "_", "");
            fs = Format.replace(fs, "[Red]", "");
            fs = Format.replace(fs, "\\", "");
            fs = Format.replace(fs, "\"", "");
            fs = Format.replaceBad(fs);
            DecimalFormat f = new DecimalFormat(fs);
            f.setRoundingMode(RoundingMode.HALF_UP);
            this.format = f;
        }
        catch (IllegalArgumentException e) {
            DecimalFormat f = new DecimalFormat("#.###");
            f.setRoundingMode(RoundingMode.HALF_UP);
            this.format = f;
        }
        return (NumberFormat)this.format;
    }

    public final DateFormat getDateFormat() {
        int end;
        StringBuffer sb;
        String formatString;
        if (this.format != null && this.format instanceof DateFormat) {
            return (DateFormat)this.format;
        }
        this.content = Format.replace(this.content, "\"", "");
        String fmt = formatString = Format.replaceBad(this.content);
        int pos = fmt.indexOf("AM/PM");
        while (pos != -1) {
            sb = new StringBuffer(fmt.substring(0, pos));
            sb.append('a');
            sb.append(fmt.substring(pos + 5));
            fmt = sb.toString();
            pos = fmt.indexOf("AM/PM");
        }
        pos = fmt.indexOf("ss.0");
        while (pos != -1) {
            sb = new StringBuffer(fmt.substring(0, pos));
            sb.append("ss.SSS");
            pos += 4;
            while (pos < fmt.length() && fmt.charAt(pos) == '0') {
                ++pos;
            }
            sb.append(fmt.substring(pos));
            fmt = sb.toString();
            pos = fmt.indexOf("ss.0");
        }
        sb = new StringBuffer();
        for (int i = 0; i < fmt.length(); ++i) {
            if (fmt.charAt(i) == '\\') continue;
            sb.append(fmt.charAt(i));
        }
        fmt = sb.toString();
        if (fmt.charAt(0) == '[' && (end = fmt.indexOf(93)) != -1) {
            fmt = fmt.substring(end + 1);
        }
        fmt = Format.replace(fmt, ";@", "");
        char[] formatBytes = fmt.toCharArray();
        for (int i = 0; i < formatBytes.length; ++i) {
            char ind;
            int j;
            int j2;
            if (formatBytes[i] != 'm') continue;
            if (i > 0 && (formatBytes[i - 1] == 'm' || formatBytes[i - 1] == 'M')) {
                formatBytes[i] = formatBytes[i - 1];
                continue;
            }
            int minuteDist = Integer.MAX_VALUE;
            for (j2 = i - 1; j2 > 0; --j2) {
                if (formatBytes[j2] != 'h') continue;
                minuteDist = i - j2;
                break;
            }
            for (j2 = i + 1; j2 < formatBytes.length; ++j2) {
                if (formatBytes[j2] != 'h') continue;
                minuteDist = Math.min(minuteDist, j2 - i);
                break;
            }
            for (j2 = i - 1; j2 > 0; --j2) {
                if (formatBytes[j2] != 'H') continue;
                minuteDist = i - j2;
                break;
            }
            for (j2 = i + 1; j2 < formatBytes.length; ++j2) {
                if (formatBytes[j2] != 'H') continue;
                minuteDist = Math.min(minuteDist, j2 - i);
                break;
            }
            for (j2 = i - 1; j2 > 0; --j2) {
                if (formatBytes[j2] != 's') continue;
                minuteDist = Math.min(minuteDist, i - j2);
                break;
            }
            for (j2 = i + 1; j2 < formatBytes.length; ++j2) {
                if (formatBytes[j2] != 's') continue;
                minuteDist = Math.min(minuteDist, j2 - i);
                break;
            }
            int monthDist = Integer.MAX_VALUE;
            for (j = i - 1; j > 0; --j) {
                if (formatBytes[j] != 'd') continue;
                monthDist = i - j;
                break;
            }
            for (j = i + 1; j < formatBytes.length; ++j) {
                if (formatBytes[j] != 'd') continue;
                monthDist = Math.min(monthDist, j - i);
                break;
            }
            for (j = i - 1; j > 0; --j) {
                if (formatBytes[j] != 'y') continue;
                monthDist = Math.min(monthDist, i - j);
                break;
            }
            for (j = i + 1; j < formatBytes.length; ++j) {
                if (formatBytes[j] != 'y') continue;
                monthDist = Math.min(monthDist, j - i);
                break;
            }
            if (monthDist < minuteDist) {
                formatBytes[i] = Character.toUpperCase(formatBytes[i]);
                continue;
            }
            if (monthDist != minuteDist || monthDist == Integer.MAX_VALUE || (ind = formatBytes[i - monthDist]) != 'y' && ind != 'd') continue;
            formatBytes[i] = Character.toUpperCase(formatBytes[i]);
        }
        try {
            this.format = new SimpleDateFormat(new String(formatBytes));
        }
        catch (IllegalArgumentException e) {
            this.format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        }
        return (DateFormat)this.format;
    }

    public String floatFormat(double value) {
        try {
            int i;
            int exponential;
            double newValue = value;
            String newValueStr = String.valueOf(newValue);
            int eindex = newValueStr.toUpperCase().indexOf("E");
            String format = "";
            if (eindex == -1) {
                return newValueStr;
            }
            String cardinalNumberStr = newValueStr.substring(0, eindex);
            String exponentialStr = newValueStr.substring(eindex + 1);
            if (exponentialStr.startsWith("+")) {
                exponentialStr = exponentialStr.substring(1);
            }
            if ((exponential = Integer.parseInt(exponentialStr)) > 0) {
                if (cardinalNumberStr.length() - 2 - exponential > 0) {
                    format = "#.";
                    for (i = 0; i < cardinalNumberStr.length() - 2 - exponential; ++i) {
                        format = format + 0;
                    }
                } else {
                    format = "#.0";
                }
            } else if (exponential < 0) {
                format = "0.";
                for (i = 0; i < cardinalNumberStr.substring(cardinalNumberStr.indexOf(".") + 1).length() - exponential; ++i) {
                    format = format + 0;
                }
            } else {
                format = "#.0";
            }
            if (format.length() == 2) {
                format = format + 0;
            }
            DecimalFormat df = new DecimalFormat(format);
            df.setRoundingMode(RoundingMode.HALF_UP);
            return df.format(newValue);
        }
        catch (Exception e) {
            return String.valueOf(value);
        }
    }

    public static String replaceBad(String str) {
        StringBuffer sb = new StringBuffer();
        char[] ss = str.toCharArray();
        boolean flag = false;
        for (int i = 0; i < ss.length; ++i) {
            if (ss[i] == '[') {
                flag = true;
            }
            if (ss[i] == ']') {
                flag = false;
            }
            if (flag || ss[i] == ']') continue;
            sb.append(ss[i]);
        }
        return sb.toString();
    }

    public static boolean isTimeFormat(String format) {
        for (int i = 0; i < TIME_STRINGS.length; ++i) {
            if (format.indexOf(TIME_STRINGS[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isDateFormat(String format) {
        for (int i = 0; i < DATE_STRINGS.length; ++i) {
            if (format.indexOf(DATE_STRINGS[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public int getIndex() {
        return this.index;
    }

    public int getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String toString() {
        return "{" + this.index + "," + this.type + "," + this.content + "}";
    }

    public static void main(String[] args) {
        System.out.println(Format.replaceBad("[dbdd]111[aaa]333"));
    }
}

