/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.parser.globals;

import edu.npu.fastexcel.ExcelException;
import edu.npu.fastexcel.biff.parser.ParserException;
import edu.npu.fastexcel.biff.parser.globals.WorkBookParser;
import edu.npu.fastexcel.biff.read.RecordReader;
import edu.npu.fastexcel.biff.record.ReadOnlyRecord;
import edu.npu.fastexcel.common.util.NumUtil;
import edu.npu.fastexcel.common.util.StringUtil;
import edu.npu.fastexcel.compound.io.ReadException;

public class SSTParser
extends WorkBookParser {
    public static final int STRING_MASK_CCOMPR = 1;
    public static final int STRING_MASK_PHONETIC = 4;
    public static final int STRING_MASK_RICHTEXT = 8;

    public SSTParser() {
        super(252);
    }

    @Override
    public void parse() throws ParserException {
        int total = NumUtil.getInt(this.b[this.off], this.b[this.off + 1], this.b[this.off + 2], this.b[this.off + 3]);
        int nm = NumUtil.getInt(this.b[this.off + 4], this.b[this.off + 5], this.b[this.off + 6], this.b[this.off + 7]);
        int t = this.off + 8;
        try {
            this.getSSTEntries(t, nm, this.b);
            this.workBookGlobalsStream.setTotalString(total);
        }
        catch (ReadException e) {
            throw new ParserException(e);
        }
    }

    private final void getSSTEntries(int offset, int nm, byte[] bytes) throws ReadException {
        ResultHolder rh = new ResultHolder();
        rh.offset = offset;
        rh.bytes = bytes;
        rh.recordReader = this.context.getStreamReader();
        try {
            for (int i = 0; i < nm; ++i) {
                this.workBookGlobalsStream.addSST(this.getSSTString(rh));
            }
        }
        catch (ExcelException e) {
            throw new ReadException(e);
        }
    }

    private final String getString(boolean ascii, int len, ResultHolder holder) throws ReadException {
        int span;
        int byteLen = len;
        byte[] bb = holder.getByte();
        if (!ascii) {
            byteLen *= 2;
        }
        if ((span = holder.isSpanBreak(byteLen)) <= 0) {
            String str;
            if (ascii) {
                str = StringUtil.getASCIIString(bb, holder.offset, len);
                holder.offset += len;
            } else {
                str = StringUtil.getUnicodeString(bb, holder.offset, len);
                holder.offset += len * 2;
            }
            if (span == 0) {
                ++holder.index;
                holder.offset = 4;
            }
            return str;
        }
        int maxChar = holder.maxCharLen(ascii);
        String str = ascii ? StringUtil.getASCIIString(bb, holder.offset, maxChar) : StringUtil.getUnicodeString(bb, holder.offset, maxChar);
        String continueStr = this.getContinueString(holder, len - maxChar);
        return str + continueStr;
    }

    private final String getContinueString(ResultHolder holder, int len) throws ReadException {
        StringBuffer sb = new StringBuffer();
        int charLeft = len;
        while (charLeft > 0) {
            int read;
            ++holder.index;
            holder.offset = 4;
            byte[] bb = holder.getByte();
            if (bb[holder.offset] == 0) {
                ++holder.offset;
                read = holder.continueToRead(true, charLeft);
                sb.append(StringUtil.getASCIIString(bb, holder.offset, read));
                holder.offset += read;
                charLeft -= read;
                continue;
            }
            ++holder.offset;
            read = holder.continueToRead(false, charLeft);
            sb.append(StringUtil.getUnicodeString(bb, holder.offset, read));
            holder.offset += read * 2;
            charLeft -= read;
        }
        return sb.toString();
    }

    private final String getSSTString(ResultHolder holder) throws ReadException {
        int ll;
        byte[] b = holder.getByte();
        int ln = NumUtil.getInt(b[holder.offset], b[holder.offset + 1]);
        byte f = b[holder.offset + 2];
        holder.offset += 3;
        boolean ccompr = (f & 1) == 0;
        boolean phonetic = (f & 4) == 0;
        boolean richtext = (f & 8) == 0;
        int incr = 0;
        int rt = 0;
        int sz = 0;
        String name = "";
        if (!richtext) {
            rt = NumUtil.getInt(b[holder.offset], b[holder.offset + 1]);
            incr += 2;
        }
        if (!phonetic) {
            sz = NumUtil.getInt(b[holder.offset + incr], b[holder.offset + incr + 1], b[holder.offset + incr + 2], b[holder.offset + incr + 3]);
            incr += 4;
        }
        holder.offset += incr;
        name = !ccompr ? this.getString(false, ln, holder) : this.getString(true, ln, holder);
        if (!richtext) {
            holder.offset += rt * 4;
        }
        if (!phonetic) {
            holder.offset += sz;
        }
        if ((ll = holder.offset - holder.getByte().length) >= 0) {
            ++holder.index;
            holder.offset = ll + 4;
        }
        return name;
    }

    private class ResultHolder {
        int index = 0;
        int currentIndex = 0;
        int offset = 0;
        byte[] bytes;
        RecordReader recordReader;

        public int isSpanBreak(int byteToRead) {
            byte[] bb = this.bytes;
            return this.offset + byteToRead - bb.length;
        }

        public byte[] getByte() throws ReadException {
            if (this.currentIndex == this.index) {
                return this.bytes;
            }
            ReadOnlyRecord record = new ReadOnlyRecord();
            this.recordReader.nextRecord(record);
            if (record.getType() != 60) {
                this.recordReader.undoNext();
                return new byte[0];
            }
            this.bytes = record.getBytes();
            ++this.currentIndex;
            return this.bytes;
        }

        public int maxCharLen(boolean ascii) {
            if (ascii) {
                return this.bytes.length - this.offset;
            }
            return (this.bytes.length - this.offset) / 2;
        }

        private boolean hasContinue() throws ReadException {
            ReadOnlyRecord record = new ReadOnlyRecord();
            this.recordReader.nextRecord(record);
            boolean result = record.getType() == 60;
            this.recordReader.undoNext();
            return result;
        }

        public int continueToRead(boolean ascii, int charLeft) throws ReadException {
            if (ascii) {
                return !this.hasContinue() ? charLeft : Math.min(charLeft, this.bytes.length - this.offset);
            }
            return !this.hasContinue() ? charLeft : Math.min(charLeft, (this.bytes.length - this.offset) / 2);
        }

        public String toString() {
            return "ResultHolder [currentIndex=" + this.currentIndex + ", index=" + this.index + ", offset=" + this.offset + "]";
        }
    }
}

