/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.read;

import edu.npu.fastexcel.BIFFSetting;
import edu.npu.fastexcel.ExcelException;
import edu.npu.fastexcel.biff.Types;
import edu.npu.fastexcel.biff.parser.ParserException;
import edu.npu.fastexcel.biff.parser.ParserFactory;
import edu.npu.fastexcel.biff.read.AbstractSheetStream;
import edu.npu.fastexcel.biff.read.DefaultRecordReader;
import edu.npu.fastexcel.biff.read.ParserContextImpl;
import edu.npu.fastexcel.biff.read.SubStream;
import edu.npu.fastexcel.biff.read.WorkBookGlobalsStream;
import edu.npu.fastexcel.biff.read.WorkBookStream;
import edu.npu.fastexcel.biff.record.ReadOnlyRecord;
import edu.npu.fastexcel.biff.record.Record;
import edu.npu.fastexcel.compound.CompoundFileReader;
import edu.npu.fastexcel.compound.io.ReadException;
import edu.npu.fastexcel.compound.io.Reader;
import java.io.File;

public class BIFFReader {
    private File file;
    private ParserFactory parserFactory;
    private WorkBookStream workBookStream;
    private CompoundFileReader compoundFile;
    private WorkBookGlobalsStream workBookGlobalsStream;
    boolean isOpen;
    Reader reader;
    ParserContextImpl context;
    BIFFSetting setting;

    public BIFFReader(File file) {
        this.file = file;
        this.isOpen = false;
        this.parserFactory = new ParserFactory();
        this.context = new ParserContextImpl();
        this.context.setting = this.setting = new BIFFSetting();
    }

    public long getFileSize() {
        return this.file.length();
    }

    public BIFFSetting getSetting() {
        return this.setting;
    }

    public void setFile(File f) {
        if (this.isOpen) {
            throw new IllegalStateException("file already opened.close it first.");
        }
        this.file = f;
    }

    public File getFile() {
        return this.file;
    }

    public void open() throws ReadException {
        if (!this.isOpen) {
            this.compoundFile = new CompoundFileReader(this.file);
            this.compoundFile.open();
            this.workBookStream = new WorkBookStream(this.compoundFile);
            if (this.compoundFile.getReadableStream("Workbook") == null && this.compoundFile.getReadableStream("Book") == null) {
                throw new ReadException("Can not find Workbook stream.");
            }
            this.reader = this.workBookStream.reader;
            this.context.stream = this.workBookStream;
            this.context.reader = this.reader;
            this.isOpen = true;
        }
    }

    public void close() throws ReadException {
        if (this.isOpen) {
            this.reader.close();
            this.compoundFile.close();
            this.isOpen = false;
            try {
                this.workBookGlobalsStream.close();
            }
            catch (ExcelException e) {
                throw new ReadException(e);
            }
        }
    }

    public void readStream(SubStream s) throws ParserException, ReadException {
        ReadOnlyRecord record = new ReadOnlyRecord();
        DefaultRecordReader rr = new DefaultRecordReader(s, this.reader);
        rr.open();
        this.context.streamReader = rr;
        while (!s.eof) {
            rr.nextRecord(record);
            this.parserFactory.parse(record, this.context);
        }
    }

    public void readWorkBookGlobals() throws ParserException, ReadException, ExcelException {
        this.workBookGlobalsStream = new WorkBookGlobalsStream(this.setting);
        this.workBookStream.addSubStream(this.workBookGlobalsStream);
        this.workBookStream.setCurrentStream(this.workBookGlobalsStream);
        this.workBookGlobalsStream.offset = 0;
        this.readStream(this.workBookGlobalsStream);
    }

    public void readSheet(AbstractSheetStream stream) throws ParserException, ReadException {
        this.workBookStream.setCurrentStream(stream);
        this.readStream(stream);
    }

    void dumpWorkbookGlobals(WorkBookGlobalsStream ws) throws ExcelException {
        int i;
        System.out.println("WORKBOOKGLOBALS:");
        System.out.println("SST:");
        for (i = 0; i < ws.sstCount(); ++i) {
            System.out.println(i + "--" + ws.getSST(i));
        }
        for (i = 0; i < ws.sheetCount(); ++i) {
            System.out.println(i + "--" + ws.getSheetStream(i));
        }
    }

    void dump(Record record, long offset) {
        System.out.println(Integer.toHexString(record.getType()) + "--" + Types.getTypeName(record.getType()) + "--" + record.getLength() + "---" + offset);
    }

    public WorkBookStream getWorkBookStream() {
        return this.workBookStream;
    }

    public WorkBookGlobalsStream getWorkBookGlobalsStream() {
        return this.workBookGlobalsStream;
    }
}

