/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.read;

import edu.npu.fastexcel.ExcelException;
import edu.npu.fastexcel.biff.read.SST;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.TreeMap;

public class CacheFileSST
implements SST {
    private int count = 0;
    private int[] indexTable = new int[8192];
    private int[] offsetTable = new int[8192];
    private static final int INIT_INDEX_SIZE = 8192;
    private static final int GROW_SIZE = 8192;
    private File tempFile;
    private int currentPos = 0;
    private RandomAccessFile raf;
    private StringCache cache = new StringCache(256);
    private int cacheSize = 256;

    public CacheFileSST() throws ExcelException {
        String fileName = "SST" + System.currentTimeMillis();
        try {
            this.tempFile = File.createTempFile(fileName, ".tmp");
            this.raf = new RandomAccessFile(this.tempFile, "rw");
        }
        catch (IOException e) {
            throw new ExcelException(e);
        }
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        this.cache.size = cacheSize;
    }

    @Override
    public void addString(String str) throws ExcelException {
        try {
            byte[] ss = str.getBytes();
            this.raf.write(ss);
            if (this.count >= this.indexTable.length) {
                int[] grown = new int[this.indexTable.length + 8192];
                System.arraycopy(this.indexTable, 0, grown, 0, this.indexTable.length);
                this.indexTable = grown;
                int[] grown2 = new int[this.offsetTable.length + 8192];
                System.arraycopy(this.offsetTable, 0, grown2, 0, this.offsetTable.length);
                this.offsetTable = grown2;
            }
            this.indexTable[this.count] = this.currentPos;
            this.offsetTable[this.count] = ss.length;
            this.currentPos += ss.length;
            ++this.count;
        }
        catch (IOException e) {
            throw new ExcelException(e);
        }
    }

    @Override
    public void flush() throws ExcelException {
    }

    @Override
    public String getString(int index) throws ExcelException {
        if (index < 0 || index >= this.count) {
            return null;
        }
        String result = this.cache.get(index);
        if (result != null) {
            return result;
        }
        int pos = this.indexTable[index];
        int len = this.offsetTable[index];
        byte[] bb = new byte[len];
        try {
            this.raf.seek(pos);
            this.raf.read(bb);
        }
        catch (IOException e) {
            throw new ExcelException(e);
        }
        result = new String(bb);
        this.cache.put(index, result);
        return result;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public void clear() throws ExcelException {
        try {
            this.raf.close();
        }
        catch (IOException e) {
            throw new ExcelException(e);
        }
        finally {
            this.tempFile.delete();
        }
    }

    class StringCache {
        int size;
        LinkedList<String> fifoList = new LinkedList();
        TreeMap<String, String> keySet = new TreeMap();

        public StringCache(int size) {
            this.size = size;
        }

        void put(int index, String str) {
            if (this.keySet.size() > this.size) {
                String head = this.fifoList.removeFirst();
                this.keySet.remove(head);
            }
            this.keySet.put("" + index, str);
            this.fifoList.add("" + index);
        }

        String get(int index) {
            return this.keySet.get("" + index);
        }
    }
}

