/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.read;

import edu.npu.fastexcel.biff.read.RecordReader;
import edu.npu.fastexcel.biff.read.SubStream;
import edu.npu.fastexcel.biff.record.ReadOnlyRecord;
import edu.npu.fastexcel.biff.record.Readable;
import edu.npu.fastexcel.common.util.NumUtil;
import edu.npu.fastexcel.compound.io.ReadException;
import edu.npu.fastexcel.compound.io.Reader;

public class DefaultRecordReader
implements RecordReader {
    private SubStream stream;
    private int position;
    private Reader reader;
    private ReadOnlyRecord lastRecord;
    byte[] header;

    public DefaultRecordReader(SubStream s, Reader reader) {
        this.stream = s;
        this.reader = reader;
        this.position = this.stream.offset;
        this.lastRecord = new ReadOnlyRecord();
        this.header = new byte[4];
    }

    @Override
    public boolean nextRecord(Readable record) throws ReadException {
        if (this.stream.eof) {
            return false;
        }
        this.reader.seek(this.position);
        int r = this.reader.read(this.header);
        if (r == -1) {
            return false;
        }
        this.reader.seek(this.position);
        int len = NumUtil.getInt(this.header[2], this.header[3]) + 4;
        byte[] bb = new byte[len];
        record.setBytes(bb);
        r = this.reader.read(bb);
        if (r == -1) {
            return false;
        }
        this.position += len;
        this.lastRecord.setBytes(bb);
        return true;
    }

    @Override
    public void rewind() throws ReadException {
        this.position = this.stream.offset;
    }

    @Override
    public void setStream(SubStream s) {
        this.stream = s;
    }

    @Override
    public void skip(int num) throws ReadException {
        ReadOnlyRecord r = new ReadOnlyRecord();
        for (int i = 0; i < num; ++i) {
            this.nextRecord(r);
        }
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void undoNext() throws ReadException {
        if (this.lastRecord != null) {
            this.position -= this.lastRecord.getBytes().length;
        }
    }

    @Override
    public void close() throws ReadException {
        this.reader.close();
    }

    @Override
    public void open() throws ReadException {
        this.reader.open();
    }
}

