/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.read;

import edu.npu.fastexcel.ExcelException;
import edu.npu.fastexcel.biff.Dimension;
import edu.npu.fastexcel.biff.read.AbstractSheetStream;
import edu.npu.fastexcel.biff.read.SheetStream;
import edu.npu.fastexcel.biff.read.WorkBookGlobalsStream;
import java.util.ArrayList;
import java.util.HashMap;

public class DefaultSheetStream
extends AbstractSheetStream {
    private Dimension dimension = new Dimension();
    private ArrayList<String> innerStringTable;
    private int[] contentOffset;
    private HashMap<Integer, Integer> contentMap = new HashMap();

    public DefaultSheetStream(SheetStream stream, WorkBookGlobalsStream wgs) {
        super(stream, wgs);
        this.contentOffset = new int[0];
        this.innerStringTable = new ArrayList();
        this.eof = false;
    }

    private final String getContent(int index) throws ExcelException {
        if (index >= 0) {
            return this.workBookGlobalsStream.getSST(index);
        }
        return this.innerStringTable.get(index * -1 - 1);
    }

    public String getCell(int row, int col) throws ExcelException {
        if (row < this.dimension.firstRow || col < this.dimension.firstCol || row > this.dimension.lastRow || col > this.dimension.lastCol) {
            throw new ExcelException("no such cell:" + row + "," + col);
        }
        int c = (row &= 0xFFFF) << 16 | (col &= 0xFFFF);
        Integer sindex = this.contentMap.get(new Integer(c));
        if (sindex == null) {
            return null;
        }
        int index = sindex;
        return this.getContent(index);
    }

    public String[] getRow(int row) throws ExcelException {
        if (row < this.dimension.firstRow || row > this.dimension.lastRow) {
            throw new ExcelException("no such row:" + row);
        }
        int index = row - this.dimension.firstRow;
        int r = this.contentOffset[index];
        if (r == 0) {
            return null;
        }
        int cl = r & 0xFFFF;
        int cf = (r & 0xFFFF0000) >> 16;
        int count = cl - cf;
        String[] ss = new String[count];
        for (int i = 0; i < count; ++i) {
            int col = cf + i & 0xFFFF;
            int c = (row &= 0xFFFF) << 16 | col;
            Integer sindex = this.contentMap.get(new Integer(c));
            if (sindex == null) continue;
            ss[i] = this.getContent(sindex);
        }
        return ss;
    }

    @Override
    public short getFirstCol(int row) throws ExcelException {
        if (row < this.dimension.firstRow || row > this.dimension.lastRow) {
            throw new ExcelException("no such row:" + row);
        }
        int index = row - this.dimension.firstRow;
        int r = this.contentOffset[index];
        if (r == 0) {
            return 0;
        }
        int cf = (r & 0xFFFF0000) >> 16;
        return (short)cf;
    }

    @Override
    public short getLastCol(int row) throws ExcelException {
        if (row < this.dimension.firstRow || row > this.dimension.lastRow) {
            throw new ExcelException("no such row:" + row);
        }
        int index = row - this.dimension.firstRow;
        int r = this.contentOffset[index];
        if (r == 0) {
            return 0;
        }
        int cl = r & 0xFFFF;
        return (short)cl;
    }

    @Override
    public void setDimension(int rf, int rl, int cf, int cl) {
        if (!this.dimension.isEmpty()) {
            return;
        }
        this.dimension.firstRow = rf;
        this.dimension.firstCol = cf;
        this.dimension.lastRow = rl;
        this.dimension.lastCol = cl;
        this.contentOffset = new int[rl - rf + 1];
    }

    @Override
    public void setRow(int row, int cf, int cl) {
        int c;
        int index = row - this.dimension.firstRow;
        this.contentOffset[index] = c = (cf &= 0xFFFFFFFF) << 16 | (cl &= 0xFFFFFFFF);
    }

    @Override
    public void setContent(int row, int col, int sstIndex) {
        if (row < this.dimension.firstRow || row > this.dimension.lastRow || col < this.dimension.firstCol || col > this.dimension.lastCol) {
            return;
        }
        int c = (row &= 0xFFFF) << 16 | (col &= 0xFFFF);
        this.contentMap.put(new Integer(c), new Integer(sstIndex));
    }

    @Override
    public void setContent(int row, int col, String str) {
        this.innerStringTable.add(str);
        int c = (row &= 0xFFFF) << 16 | (col &= 0xFFFF);
        this.contentMap.put(new Integer(c), new Integer(this.innerStringTable.size() * -1));
    }

    public int getLastRow() {
        return this.dimension.lastRow;
    }

    public int getFirstColumn() {
        return this.dimension.firstCol;
    }

    public int getFirstRow() {
        return this.dimension.firstRow;
    }

    public int getLastColumn() {
        return this.dimension.lastCol;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{name:");
        sb.append(this.name + ",index:");
        sb.append(this.index + ",firstRow:");
        sb.append(this.dimension.firstRow + ",lastRow:");
        sb.append(this.dimension.lastRow + ",firstColumn:");
        sb.append(this.dimension.firstCol + ",lastColumn:");
        sb.append(this.dimension.lastCol + ",offset:");
        sb.append(this.offset);
        sb.append("}");
        return sb.toString();
    }
}

