/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.read;

import edu.npu.fastexcel.ExcelException;
import edu.npu.fastexcel.biff.read.SST;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileSST
implements SST {
    private int count = 0;
    private int[] indexTable = new int[8192];
    private int[] offsetTable = new int[8192];
    private static final int INIT_INDEX_SIZE = 8192;
    private static final int GROW_SIZE = 8192;
    private File tempFile;
    private int currentPos = 0;
    private RandomAccessFile raf;

    public FileSST() throws ExcelException {
        String fileName = "SST" + System.currentTimeMillis();
        try {
            this.tempFile = File.createTempFile(fileName, ".tmp");
            this.raf = new RandomAccessFile(this.tempFile, "rw");
        }
        catch (IOException e) {
            this.deleteTempFile();
            throw new ExcelException(e);
        }
    }

    private void deleteTempFile() {
        if (this.tempFile != null && this.tempFile.exists()) {
            this.tempFile.delete();
        }
    }

    @Override
    public void addString(String str) throws ExcelException {
        try {
            byte[] ss = str.getBytes();
            this.raf.write(ss);
            if (this.count >= this.indexTable.length) {
                int[] grown = new int[this.indexTable.length + 8192];
                System.arraycopy(this.indexTable, 0, grown, 0, this.indexTable.length);
                this.indexTable = grown;
                int[] grown2 = new int[this.offsetTable.length + 8192];
                System.arraycopy(this.offsetTable, 0, grown2, 0, this.offsetTable.length);
                this.offsetTable = grown2;
            }
            this.indexTable[this.count] = this.currentPos;
            this.offsetTable[this.count] = ss.length;
            this.currentPos += ss.length;
            ++this.count;
        }
        catch (IOException e) {
            this.deleteTempFile();
            throw new ExcelException(e);
        }
    }

    @Override
    public void flush() throws ExcelException {
    }

    @Override
    public String getString(int index) throws ExcelException {
        if (index < 0 || index >= this.count) {
            return null;
        }
        int pos = this.indexTable[index];
        int len = this.offsetTable[index];
        byte[] bb = new byte[len];
        try {
            this.raf.seek(pos);
            this.raf.read(bb);
        }
        catch (IOException e) {
            this.deleteTempFile();
            throw new ExcelException(e);
        }
        return new String(bb);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public void clear() throws ExcelException {
        try {
            this.raf.close();
        }
        catch (IOException e) {
            throw new ExcelException(e);
        }
        finally {
            this.tempFile.delete();
        }
    }
}

