/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.read;

import edu.npu.fastexcel.BIFFSetting;
import edu.npu.fastexcel.ExcelException;
import edu.npu.fastexcel.biff.parser.globals.BuiltinFormats;
import edu.npu.fastexcel.biff.parser.globals.Format;
import edu.npu.fastexcel.biff.parser.globals.XF;
import edu.npu.fastexcel.biff.read.ArraySST;
import edu.npu.fastexcel.biff.read.CacheFileSST;
import edu.npu.fastexcel.biff.read.FileSST;
import edu.npu.fastexcel.biff.read.SST;
import edu.npu.fastexcel.biff.read.SheetStream;
import edu.npu.fastexcel.biff.read.SubStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WorkBookGlobalsStream
extends SubStream {
    public static final int WORKBOOK_GLOBALS_POS = 512;
    private List<SheetStream> sheetList;
    private SST sstHolder;
    private ArrayList<XF> XF;
    private HashMap<String, Format> formatMap;
    private BIFFSetting setting;
    private int totalString;
    private int dateMode;

    public WorkBookGlobalsStream(BIFFSetting setting) throws ExcelException {
        this.setting = setting;
        this.sheetList = new ArrayList<SheetStream>();
        switch (this.setting.getSSTType()) {
            case 1: {
                this.sstHolder = new ArraySST();
                break;
            }
            case 3: {
                this.sstHolder = new FileSST();
                break;
            }
            case 2: {
                this.sstHolder = new CacheFileSST();
                break;
            }
            default: {
                this.sstHolder = new ArraySST();
            }
        }
        this.XF = new ArrayList(64);
        this.formatMap = new HashMap(64);
        this.offset = 512;
        this.dateMode = 0;
    }

    public SheetStream getSheetStream(int index) {
        if (index < 0 || index >= this.sheetList.size()) {
            return null;
        }
        return this.sheetList.get(index);
    }

    public int sheetCount() {
        return this.sheetList.size();
    }

    public String[] sheetNames() {
        String[] names = new String[this.sheetList.size()];
        for (int i = 0; i < this.sheetList.size(); ++i) {
            SheetStream ss = this.sheetList.get(i);
            names[i] = ss.name;
        }
        return names;
    }

    public SheetStream[] getSheets() {
        return this.sheetList.toArray(new SheetStream[this.sheetList.size()]);
    }

    public SheetStream getSheetStream(String name) {
        for (int i = 0; i < this.sheetList.size(); ++i) {
            SheetStream ss = this.sheetList.get(i);
            if (!name.equals(ss.name)) continue;
            return ss;
        }
        return null;
    }

    @Override
    public void flush() throws ExcelException {
        this.sstHolder.flush();
    }

    @Override
    public void close() throws ExcelException {
        this.sstHolder.clear();
    }

    public void addSheet(SheetStream sheet) {
        sheet.index = this.sheetList.size();
        this.sheetList.add(sheet);
    }

    public int sstCount() throws ExcelException {
        return this.sstHolder.size();
    }

    public int getTotalString() {
        return this.totalString;
    }

    public void setTotalString(int totalString) {
        this.totalString = totalString;
    }

    public String getSST(int index) throws ExcelException {
        return this.sstHolder.getString(index);
    }

    public void addSST(String str) throws ExcelException {
        this.sstHolder.addString(str);
    }

    public void addXF(XF xf) {
        this.XF.add(xf);
    }

    public XF getXF(int index) {
        return this.XF.get(index);
    }

    public void addFormat(int index, int type, String format) {
        this.formatMap.put(index + "", new Format(index, type, format));
    }

    public Format getFormat(int index) {
        Format f = this.formatMap.get("" + index);
        if (f == null) {
            return BuiltinFormats.getFormat(index);
        }
        return f;
    }

    public int getDateMode() {
        return this.dateMode;
    }

    public void setDateMode(int dateMode) {
        this.dateMode = dateMode;
    }

    @Override
    public String getName() {
        return "WORKBOOK_GLOBALS";
    }
}

