/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.record;

import edu.npu.fastexcel.biff.Types;
import edu.npu.fastexcel.common.util.NumUtil;
import java.util.ArrayList;

public abstract class Record {
    public static final int RECORD_HEADER_LENGTH = 4;
    public static final int OFFSET = 4;
    public static final int MAX_RECORD_LENGTH = 8228;
    protected byte[] bytes;
    public int position;
    private ArrayList<Record> continueList;

    public Record(byte[] bytes) {
        this.bytes = bytes;
        this.continueList = new ArrayList();
    }

    protected void setType(int type) {
        NumUtil.getTwoBytes(type, this.bytes, 0);
    }

    protected void setContentLength(int len) {
        NumUtil.getTwoBytes(len, this.bytes, 2);
    }

    public int getType() {
        return NumUtil.getInt(this.bytes[0], this.bytes[1]);
    }

    public int getContentLength() {
        return NumUtil.getInt(this.bytes[2], this.bytes[3]);
    }

    public int getLength() {
        return this.getContentLength() + 4;
    }

    public void addContinue(Record r) {
        this.continueList.add(r);
    }

    public void clearContinues() {
        this.continueList.clear();
    }

    public Record getContinue(int index) {
        return this.continueList.get(index);
    }

    public int continueCount() {
        return this.continueList.size();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toString() {
        return "{" + Types.getTypeName(this.getType()) + "}";
    }
}

