/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.record;

import edu.npu.fastexcel.biff.parser.globals.BuiltinFormats;
import edu.npu.fastexcel.biff.record.BOFRecord;
import edu.npu.fastexcel.biff.record.EOFRecord;
import edu.npu.fastexcel.biff.record.NotImplementRecord;
import edu.npu.fastexcel.biff.record.Record;
import edu.npu.fastexcel.biff.record.cell.LabelSSTRecord;
import edu.npu.fastexcel.biff.record.cell.RKRecord;
import edu.npu.fastexcel.biff.record.globals.BoundSheetRecord;
import edu.npu.fastexcel.biff.record.globals.DateModeRecord;
import edu.npu.fastexcel.biff.record.globals.FormatRecord;
import edu.npu.fastexcel.biff.record.globals.SSTRecord;
import edu.npu.fastexcel.biff.record.globals.XFRecord;
import edu.npu.fastexcel.biff.record.sheet.DimensionRecord;

public class RecordFactory {
    private BoundSheetRecord boundSheet = new BoundSheetRecord();
    private FormatRecord format = new FormatRecord();
    private SSTRecord sst;
    private XFRecord xf;
    private DimensionRecord dimension;
    private LabelSSTRecord label;
    private RKRecord rk;

    private RecordFactory() {
        this.format.setIndex(0);
        this.format.setFormatString(BuiltinFormats.getFormat(0).getContent());
        this.sst = new SSTRecord();
        this.xf = new XFRecord();
        this.xf.setFont(0);
        this.xf.setFormat(0);
        this.dimension = new DimensionRecord();
        this.label = new LabelSSTRecord();
        this.rk = new RKRecord();
    }

    public Record getDimension() {
        return this.dimension;
    }

    public Record getFont() {
        return null;
    }

    public Record getCountry() {
        return null;
    }

    public Record getSST() {
        return this.sst;
    }

    public Record getDateMode1900() {
        return DateModeRecord.DATE_MODE_1899;
    }

    public Record getRK() {
        return this.rk;
    }

    public Record getIndex() {
        return null;
    }

    public Record getFormat() {
        return this.format;
    }

    public Record getXF() {
        return this.xf;
    }

    public Record getLabel() {
        return this.label;
    }

    public Record getWriteAccess() {
        return null;
    }

    public Record getCodePage() {
        return null;
    }

    public Record getBoundSheet() {
        return this.boundSheet;
    }

    public Record getGlobalsBOF() {
        return BOFRecord.BIFF_TYPE_WORKBOOK_GLOBALS;
    }

    public Record getEOF() {
        return EOFRecord.EOF;
    }

    public Record getSheetBOF() {
        return BOFRecord.BIFF_TYPE_SHEET_OR_DIALOGUE;
    }

    public Record getInterFaceEnd() {
        return NotImplementRecord.INTERFACEEND;
    }

    public Record getInterFaceHdr() {
        return NotImplementRecord.INTERFACEHDR;
    }

    public Record getMms() {
        return NotImplementRecord.MMS;
    }

    public Record getDsf() {
        return NotImplementRecord.DSF;
    }

    public Record getTabId() {
        return NotImplementRecord.TABID;
    }

    public Record getButtonPropertySet() {
        return NotImplementRecord.BUTTONPROPERTYSET;
    }

    public Record getFngroupCount() {
        return NotImplementRecord.FNGROUPCOUNT;
    }

    public Record getWindowProtect() {
        return NotImplementRecord.WINDOWPROTECT;
    }

    public Record getProtect() {
        return NotImplementRecord.PROTECT;
    }

    public Record getPassword() {
        return NotImplementRecord.PASSWORD;
    }

    public Record getProt4Rev() {
        return NotImplementRecord.PROT4REV;
    }

    public Record getWindow1() {
        return NotImplementRecord.WINDOW1;
    }

    public Record getBackup() {
        return NotImplementRecord.BACKUP;
    }

    public Record getHideObj() {
        return NotImplementRecord.HIDEOBJ;
    }

    public Record getDateMode() {
        return DateModeRecord.DATE_MODE_1899;
    }

    public Record getPrecision() {
        return NotImplementRecord.PRECISION;
    }

    public Record getRefreShall() {
        return NotImplementRecord.REFRESHALL;
    }

    public Record getBookbool() {
        return NotImplementRecord.BOOKBOOL;
    }

    public Record getCalcMode() {
        return NotImplementRecord.CALCMODE;
    }

    public Record getRefMode() {
        return NotImplementRecord.REFMODE;
    }

    public Record getIteration() {
        return NotImplementRecord.ITERATION;
    }

    public Record getDelta() {
        return NotImplementRecord.DELTA;
    }

    public Record getSaveRecalc() {
        return NotImplementRecord.SAVERECALC;
    }

    public Record getPrintHeaders() {
        return NotImplementRecord.PRINTHEADERS;
    }

    public Record getPrintGridLines() {
        return NotImplementRecord.PRINTGRIDLINES;
    }

    public Record getGridSet() {
        return NotImplementRecord.GRIDSET;
    }

    public Record getGuts() {
        return NotImplementRecord.GUTS;
    }

    public Record getDefaultRowHeight() {
        return NotImplementRecord.DEFAULTROWHEIGHT;
    }

    public Record getWsBool() {
        return NotImplementRecord.WSBOOL;
    }

    public Record getHeader() {
        return NotImplementRecord.HEADER;
    }

    public Record getFooter() {
        return NotImplementRecord.FOOTER;
    }

    public Record getHCenter() {
        return NotImplementRecord.HCENTER;
    }

    public Record getVCenter() {
        return NotImplementRecord.VCENTER;
    }

    public Record getSetup() {
        return NotImplementRecord.SETUP;
    }

    public Record getDefColWidth() {
        return NotImplementRecord.DEFCOLWIDTH;
    }

    public Record getWindow2() {
        return NotImplementRecord.WINDOW2;
    }

    public Record getWeid1() {
        return NotImplementRecord.WEIRD1;
    }

    public static RecordFactory getInstance() {
        return InstanceHolder.instance;
    }

    static class InstanceHolder {
        static RecordFactory instance = new RecordFactory();

        InstanceHolder() {
        }
    }
}

