/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.record.globals;

import edu.npu.fastexcel.biff.record.Record;
import edu.npu.fastexcel.common.util.NumUtil;
import edu.npu.fastexcel.common.util.StringUtil;

public class BoundSheetRecord
extends Record {
    private String name;
    private int streamPosition;

    public BoundSheetRecord() {
        super(new byte[0]);
        this.setName("default");
    }

    public void setName(String name) {
        this.name = name;
        int len = name.length() * 2 + 6 + 4 + 2;
        this.bytes = new byte[len];
    }

    public void setStreamPosition(int pos) {
        this.streamPosition = pos;
    }

    private void setStreamPosition() {
        NumUtil.getFourBytes(this.streamPosition, this.bytes, 4);
    }

    private void setSheetState(byte sheetState) {
        this.bytes[8] = sheetState;
    }

    private void setSheetType(byte type) {
        this.bytes[9] = type;
    }

    private void setName() {
        this.bytes[10] = (byte)this.name.length();
        this.bytes[11] = 1;
        StringUtil.getUnicodeBytes(this.name, this.bytes, 12);
    }

    @Override
    public byte[] getBytes() {
        this.setType(133);
        this.setContentLength(this.bytes.length - 4);
        this.setStreamPosition();
        this.setSheetState((byte)1);
        this.setSheetType((byte)0);
        this.setName();
        return super.getBytes();
    }

    @Override
    public String toString() {
        return "{BOUNDSHEET:" + this.name + "," + this.position + "," + this.streamPosition + "}";
    }
}

