/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.record.globals;

import edu.npu.fastexcel.biff.record.ContinueRecord;
import edu.npu.fastexcel.common.util.StringUtil;

public class SSTContinueRecord
extends ContinueRecord {
    SSTContinueRecord next = null;
    int currentRecordLength = 4;

    public SSTContinueRecord getLast() {
        SSTContinueRecord temp = this;
        while (temp.next != null) {
            temp = temp.next;
        }
        return temp;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public byte[] getBytes() {
        byte[] t = this.bytes;
        this.bytes = new byte[4];
        this.setType(60);
        return t;
    }

    public byte[] getAllBytes() {
        byte[] bb = new byte[]{};
        SSTContinueRecord temp = this;
        while (temp != null) {
            byte[] mbb = temp.getBytes();
            byte[] nbb = new byte[mbb.length + bb.length];
            System.arraycopy(bb, 0, nbb, 0, bb.length);
            System.arraycopy(mbb, 0, nbb, bb.length, mbb.length);
            bb = nbb;
            temp = temp.next;
        }
        return bb;
    }

    public void addString(String str) {
        int charLeft = str.length();
        if (this.currentRecordLength + 5 > 8228) {
            SSTContinueRecord cr = new SSTContinueRecord();
            cr.addString(str);
            this.next = cr;
            return;
        }
        this.currentRecordLength += 3;
        int spaceLeft = (8228 - this.currentRecordLength) / 2;
        if (spaceLeft >= charLeft) {
            this.addByte(StringUtil.getBIFFBytes(str));
            this.currentRecordLength += charLeft * 2;
        } else {
            SSTContinueRecord r;
            byte[] bb = StringUtil.getBIFFBytes(str);
            byte[] result = new byte[3 + spaceLeft * 2];
            System.arraycopy(bb, 0, result, 0, result.length);
            this.addByte(result);
            this.next = r = new SSTContinueRecord();
            r.addSubString(str, charLeft -= spaceLeft);
        }
    }

    public void addSubString(String str, int charLeft) {
        ++this.currentRecordLength;
        byte[] b = new byte[]{1};
        this.addByte(b);
        int spaceLeft = (8228 - this.currentRecordLength) / 2;
        int len = str.length();
        int index = len - charLeft;
        byte[] bb = StringUtil.getBIFFBytes(str);
        if (spaceLeft >= charLeft) {
            byte[] nbb = new byte[charLeft * 2];
            System.arraycopy(bb, 3 + index * 2, nbb, 0, nbb.length);
            this.addByte(nbb);
            this.currentRecordLength += charLeft * 2;
        } else {
            SSTContinueRecord r;
            byte[] nbb = new byte[spaceLeft * 2];
            System.arraycopy(bb, 3 + index * 2, nbb, 0, nbb.length);
            this.addByte(nbb);
            this.currentRecordLength += spaceLeft * 2;
            this.next = r = new SSTContinueRecord();
            r.addSubString(str, charLeft -= spaceLeft);
        }
    }

    public static void main(String[] args) {
        SSTContinueRecord sr = new SSTContinueRecord();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 6000; ++i) {
            sb.append("A");
        }
        sr.addString("VVVVVVV");
        sr.addString("CCC");
        sr.getLast();
        String str = StringUtil.dumpBytes(sr.getAllBytes());
        System.out.println(str);
    }
}

