/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.record.globals;

import edu.npu.fastexcel.biff.record.Record;
import edu.npu.fastexcel.biff.record.globals.SSTContinueRecord;
import edu.npu.fastexcel.common.util.NumUtil;
import edu.npu.fastexcel.common.util.StringUtil;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class SSTRecord
extends Record {
    private int totalString = 0;
    private int len = 0;
    private int uniqueString = -1;
    private Set<InnerString> stringSet = new TreeSet<InnerString>();
    private int currentRecordLength = 12;

    public SSTRecord() {
        super(new byte[0]);
    }

    public int addString(String str) {
        ++this.totalString;
        InnerString is = new InnerString();
        is.str = str;
        is.id = -1;
        if (this.stringSet.contains(is)) {
            return is.id;
        }
        is.id = ++this.uniqueString;
        this.stringSet.add(is);
        if (is.id != this.uniqueString) {
            --this.uniqueString;
        } else {
            this.computeLength(str);
        }
        return is.id;
    }

    public ByteReader getByteReader() {
        return new ByteReader(this);
    }

    private void computeLength(String str) {
        if (this.currentRecordLength == -1) {
            return;
        }
        if (this.currentRecordLength + 5 > 8228) {
            this.len += this.currentRecordLength;
            this.currentRecordLength = -1;
            return;
        }
        this.currentRecordLength += 3;
        int charLeft = str.length();
        int spaceLeft = (8228 - this.currentRecordLength) / 2;
        while (charLeft > 0) {
            if (spaceLeft >= charLeft) {
                this.currentRecordLength += charLeft * 2;
                charLeft = 0;
                continue;
            }
            charLeft -= spaceLeft;
            this.currentRecordLength += spaceLeft * 2;
            this.len += this.currentRecordLength;
            this.currentRecordLength = -1;
            return;
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.len == 0) {
            this.len = this.currentRecordLength;
        }
        this.bytes = new byte[12];
        this.setType(252);
        this.setContentLength(this.len - 4);
        NumUtil.getFourBytes(this.totalString, this.bytes, 4);
        NumUtil.getFourBytes(this.uniqueString + 1, this.bytes, 8);
        return this.bytes;
    }

    @Override
    public String toString() {
        if (this.len == 0) {
            this.len = this.currentRecordLength;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("uniqueStrings:" + (this.uniqueString + 1) + "\n");
        sb.append("totalStrings:" + this.totalString + "\n");
        sb.append("len:" + this.len + "\n");
        Iterator<InnerString> it = this.stringSet.iterator();
        while (it.hasNext()) {
            sb.append(it.next() + "\n");
        }
        return sb.toString();
    }

    public class ByteReader {
        SSTRecord record;
        Iterator<InnerString> iterator;
        boolean first = true;
        int charLeft;
        byte[] buffer;
        String string;
        int crl;
        SSTContinueRecord continueRecord;

        public ByteReader(SSTRecord record) {
            this.record = record;
            this.iterator = record.stringSet.iterator();
            this.buffer = record.getBytes();
            this.crl = this.buffer.length;
        }

        public byte[] read() {
            boolean lastState = true;
            while (this.iterator.hasNext()) {
                String str = this.iterator.next().str;
                if (this.addString(str)) {
                    byte[] r = this.buffer;
                    this.buffer = new byte[0];
                    lastState = true;
                    return r;
                }
                lastState = false;
            }
            if (!lastState) {
                lastState = true;
                return this.continueRecord == null ? this.buffer : this.continueRecord.getAllBytes();
            }
            return null;
        }

        public boolean addString(String str) {
            if (this.continueRecord == null) {
                if (this.crl + 5 > 8228) {
                    this.continueRecord = new SSTContinueRecord();
                    this.continueRecord.addString(str);
                    if (this.continueRecord.hasNext()) {
                        this.addToBuffer(this.continueRecord.getAllBytes());
                        this.continueRecord = this.continueRecord.getLast();
                    }
                    return true;
                }
                this.string = str;
                byte[] temp = StringUtil.getBIFFBytes(str);
                this.charLeft = this.string.length();
                this.crl += 3;
                int spaceLeft = (8228 - this.crl) / 2;
                if (spaceLeft >= this.charLeft) {
                    this.addToBuffer(temp);
                    this.crl += this.charLeft * 2;
                    this.charLeft = 0;
                    return false;
                }
                byte[] tt = new byte[3 + spaceLeft * 2];
                System.arraycopy(temp, 0, tt, 0, tt.length);
                this.addToBuffer(tt);
                this.charLeft -= spaceLeft;
                this.continueRecord = new SSTContinueRecord();
                this.continueRecord.addSubString(str, this.charLeft);
                if (this.continueRecord.hasNext()) {
                    this.addToBuffer(this.continueRecord.getAllBytes());
                    this.continueRecord = this.continueRecord.getLast();
                }
                return true;
            }
            this.continueRecord.addString(str);
            if (this.continueRecord.hasNext()) {
                this.addToBuffer(this.continueRecord.getAllBytes());
                this.continueRecord = this.continueRecord.getLast();
                return true;
            }
            return false;
        }

        private void addToBuffer(byte[] b) {
            byte[] nb = new byte[b.length + this.buffer.length];
            System.arraycopy(this.buffer, 0, nb, 0, this.buffer.length);
            System.arraycopy(b, 0, nb, this.buffer.length, b.length);
            this.buffer = nb;
        }
    }

    public class InnerString
    implements Comparable<InnerString> {
        int id;
        String str;

        @Override
        public int compareTo(InnerString o) {
            InnerString other = o;
            if (this.str.equals(other.str)) {
                this.id = other.id;
                return 0;
            }
            if (this.id == -1) {
                return -1;
            }
            return this.id - other.id;
        }

        public String toString() {
            return this.id + "-" + this.str;
        }
    }
}

