/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.write;

import edu.npu.fastexcel.biff.Dimension;
import edu.npu.fastexcel.biff.record.Record;
import edu.npu.fastexcel.biff.record.RecordFactory;
import edu.npu.fastexcel.biff.record.cell.LabelSSTRecord;
import edu.npu.fastexcel.biff.record.sheet.DimensionRecord;
import edu.npu.fastexcel.biff.record.sheet.RowRecord;
import edu.npu.fastexcel.biff.write.SheetWriter;
import edu.npu.fastexcel.biff.write.StreamWriter;
import edu.npu.fastexcel.biff.write.WorkBookGlobalsStreamWriter;
import edu.npu.fastexcel.common.util.StringUtil;
import edu.npu.fastexcel.compound.io.WriteException;
import java.util.Arrays;
import java.util.TreeSet;

public class DefaultSheetStreamWriter
implements StreamWriter,
SheetWriter {
    private int position;
    private String name;
    private Dimension dimension;
    private TreeSet<Row> recordSet;
    private int index;
    WorkBookGlobalsStreamWriter workBookGlobalsStreamWriter;
    RecordFactory factory;

    @Override
    public int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    public DefaultSheetStreamWriter(WorkBookGlobalsStreamWriter writer, RecordFactory factory) {
        this.workBookGlobalsStreamWriter = writer;
        this.factory = factory;
        this.dimension = new Dimension();
    }

    @Override
    public void open() throws WriteException {
        this.recordSet = new TreeSet();
        this.dimension.firstRow = 65536;
        this.dimension.firstCol = 256;
        this.dimension.lastCol = -1;
        this.dimension.lastRow = 0;
    }

    @Override
    public void close() throws WriteException {
    }

    @Override
    public int position() throws WriteException {
        return this.position;
    }

    @Override
    public void flush() throws WriteException {
        this.position = this.workBookGlobalsStreamWriter.position();
        this.writeCommonStart();
        this.writeDimension();
        this.writeCell();
        this.writeCommonEnd();
    }

    @Override
    public void addRow(String[] cell) throws WriteException {
        throw new IllegalStateException("Not Support Yet");
    }

    @Override
    public void setCell(int row, int col, String str) throws WriteException {
        if (row < 0 || col < 0 || row > 65536 || col > 256) {
            throw new WriteException("Bad dimension:" + row + "-" + col);
        }
        if (str == null || str.trim().equals("")) {
            return;
        }
        if (str.length() > 65536) {
            throw new WriteException("Cell string length should less than 65536");
        }
        int index = this.workBookGlobalsStreamWriter.addSharedString(str);
        this.setCell(row, col, index);
    }

    private void setDimension(int row, int col) {
        if (row < this.dimension.firstRow) {
            this.dimension.firstRow = row;
        }
        if (row >= this.dimension.lastRow) {
            this.dimension.lastRow = row + 1;
        }
        if (col < this.dimension.firstCol) {
            this.dimension.firstCol = col;
        }
        if (col >= this.dimension.lastCol) {
            this.dimension.lastCol = col + 1;
        }
    }

    private void setCell(int row, int col, int sst) {
        this.setDimension(row, col);
        Row r = new Row();
        r.column.index = row;
        if (this.recordSet.contains(r)) {
            r.setCell(row, col, sst);
        } else {
            r.column.firstColumn = col;
            r.column.lastColumn = col;
            r.column.array = new int[1];
            r.column.array[0] = sst;
            this.recordSet.add(r);
        }
    }

    private void writeCommonStart() throws WriteException {
        this.writeRecord(this.factory.getSheetBOF());
        this.writeRecord(this.factory.getCalcMode());
        this.writeRecord(this.factory.getRefMode());
        this.writeRecord(this.factory.getIteration());
        this.writeRecord(this.factory.getDelta());
        this.writeRecord(this.factory.getSaveRecalc());
        this.writeRecord(this.factory.getPrintHeaders());
        this.writeRecord(this.factory.getGridSet());
        this.writeRecord(this.factory.getGuts());
        this.writeRecord(this.factory.getDefaultRowHeight());
        this.writeRecord(this.factory.getWsBool());
        this.writeRecord(this.factory.getHeader());
        this.writeRecord(this.factory.getFooter());
        this.writeRecord(this.factory.getHCenter());
        this.writeRecord(this.factory.getVCenter());
        this.writeRecord(this.factory.getSetup());
        this.writeRecord(this.factory.getDefColWidth());
    }

    private void writeCommonEnd() throws WriteException {
        this.writeRecord(this.factory.getWindow2());
        this.writeRecord(this.factory.getWeid1());
        this.writeRecord(this.factory.getButtonPropertySet());
        this.writeRecord(this.factory.getEOF());
    }

    private void writeDimension() throws WriteException {
        DimensionRecord dr = new DimensionRecord();
        if (this.recordSet.isEmpty()) {
            dr.setFirstColumn(0);
            dr.setFirstRow(0);
            dr.setLastColumn(0);
            dr.setLastRow(0);
        } else {
            dr.setFirstColumn(this.dimension.firstCol);
            dr.setFirstRow(this.dimension.firstRow);
            dr.setLastRow(this.dimension.lastRow);
            dr.setLastColumn(this.dimension.lastCol);
        }
        this.writeRecord(dr);
    }

    private void writeCell() throws WriteException {
        RowRecord rowRecord = new RowRecord();
        LabelSSTRecord labelSSTRecord = new LabelSSTRecord();
        for (Row row : this.recordSet) {
            rowRecord.setFirstColumn(row.column.firstColumn);
            rowRecord.setLastColumn(row.column.lastColumn);
            rowRecord.setIndex(row.column.index);
            this.writeRecord(rowRecord);
            labelSSTRecord.setRow(row.column.index);
            labelSSTRecord.setXF(0);
            for (int i = 0; i < row.column.array.length; ++i) {
                if (row.column.array[i] == -1) continue;
                labelSSTRecord.setSST(row.column.array[i]);
                labelSSTRecord.setColumn(i + row.column.firstColumn);
                this.writeRecord(labelSSTRecord);
            }
        }
    }

    private void writeRecord(Record record) throws WriteException {
        this.workBookGlobalsStreamWriter.writeRecord(record);
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultSheetStreamWriter other = (DefaultSheetStreamWriter)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.dimension);
        sb.append("\n" + this.recordSet);
        return sb.toString();
    }

    class Row
    implements Comparable<Row> {
        ContentHolder column;

        public Row() {
            this.column = new ContentHolder();
        }

        public void setCell(int row, int col, int sst) {
            if (this.column.firstColumn > col) {
                this.column.firstColumn = col;
                int[] nn = new int[this.column.lastColumn - this.column.firstColumn + 1];
                Arrays.fill(nn, -1);
                System.arraycopy(this.column.array, 0, nn, 1, this.column.array.length);
                this.column.array = nn;
                this.column.array[0] = sst;
            } else if (this.column.lastColumn < col) {
                this.column.lastColumn = col;
                int[] nn = new int[this.column.lastColumn - this.column.firstColumn + 1];
                Arrays.fill(nn, -1);
                System.arraycopy(this.column.array, 0, nn, 0, this.column.array.length);
                this.column.array = nn;
                this.column.array[this.column.array.length - 1] = sst;
            } else {
                this.column.array[col - this.column.firstColumn] = sst;
            }
        }

        @Override
        public int compareTo(Row o) {
            Row other = o;
            if (other.column.index == this.column.index) {
                this.column = other.column;
                return 0;
            }
            return this.column.index - other.column.index;
        }

        public String toString() {
            return this.column.index + "," + this.column.firstColumn + "," + this.column.lastColumn + "--" + StringUtil.join(this.column.array) + "\n";
        }
    }

    class ContentHolder {
        int[] array = new int[0];
        int index;
        int firstColumn = 256;
        int lastColumn;
    }
}

