/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.write;

import edu.npu.fastexcel.biff.Dimension;
import edu.npu.fastexcel.biff.record.Record;
import edu.npu.fastexcel.biff.record.RecordFactory;
import edu.npu.fastexcel.biff.record.cell.LabelSSTRecord;
import edu.npu.fastexcel.biff.record.sheet.DimensionRecord;
import edu.npu.fastexcel.biff.record.sheet.RowRecord;
import edu.npu.fastexcel.biff.write.SheetWriter;
import edu.npu.fastexcel.biff.write.StreamWriter;
import edu.npu.fastexcel.biff.write.WorkBookGlobalsStreamWriter;
import edu.npu.fastexcel.compound.io.WriteException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class FileSheetStreamWriter
implements StreamWriter,
SheetWriter {
    private int position;
    private String name;
    private Dimension dimension;
    private int index;
    private File tempFile;
    private BufferedOutputStream bos;
    private int currentRow;
    LabelSSTRecord labelSSTRecord = new LabelSSTRecord();
    RowRecord rowRecord = new RowRecord();
    WorkBookGlobalsStreamWriter workBookGlobalsStreamWriter;
    RecordFactory factory;

    public FileSheetStreamWriter(WorkBookGlobalsStreamWriter writer, RecordFactory factory) {
        this.workBookGlobalsStreamWriter = writer;
        this.factory = factory;
        this.dimension = new Dimension();
    }

    @Override
    public void open() throws WriteException {
        String fileName = "sheet_" + this.name + "_" + System.currentTimeMillis();
        try {
            this.tempFile = File.createTempFile(fileName, ".tmp");
            this.bos = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        }
        catch (IOException e) {
            throw new WriteException("Can not create temp file:" + fileName + ".tmp", e);
        }
        this.currentRow = 0;
        this.dimension.firstRow = 0;
        this.dimension.firstCol = 0;
        this.dimension.lastCol = 0;
        this.dimension.lastRow = 0;
    }

    @Override
    public void close() throws WriteException {
        try {
            this.bos.close();
        }
        catch (IOException e) {
            throw new WriteException("Can not close temp file.", e);
        }
        finally {
            this.tempFile.delete();
        }
    }

    @Override
    public int position() throws WriteException {
        return this.position;
    }

    @Override
    public void flush() throws WriteException {
        this.position = this.workBookGlobalsStreamWriter.position();
        this.writeCommonStart();
        this.writeDimension();
        this.writeCell();
        this.writeCommonEnd();
    }

    @Override
    public void addRow(String[] cell) throws WriteException {
        if (cell == null || cell.length == 0) {
            return;
        }
        if (this.currentRow > 65536 || cell.length > 256) {
            throw new WriteException("Bad Dimension." + this.currentRow + "," + cell.length);
        }
        int[] rowcell = new int[cell.length];
        Arrays.fill(rowcell, -1);
        for (int i = 0; i < cell.length; ++i) {
            int index;
            if (cell[i] == null || cell[i].trim().length() == 0) continue;
            if (cell[i].length() > 65536) {
                throw new WriteException("Cell string length should less than 65536");
            }
            rowcell[i] = index = this.workBookGlobalsStreamWriter.addSharedString(cell[i]);
        }
        this.addRow0(this.currentRow, rowcell);
        ++this.currentRow;
    }

    private void addRow0(int row, int[] sst) throws WriteException {
        this.setDimension(row, sst.length - 1);
        this.rowRecord.setFirstColumn(0);
        this.rowRecord.setLastColumn(sst.length - 1);
        this.rowRecord.setIndex(row);
        try {
            this.bos.write(this.rowRecord.getBytes());
            for (int i = 0; i < sst.length; ++i) {
                if (sst[i] == -1) continue;
                this.labelSSTRecord.setColumn(i);
                this.labelSSTRecord.setRow(row);
                this.labelSSTRecord.setSST(sst[i]);
                this.bos.write(this.labelSSTRecord.getBytes());
            }
        }
        catch (IOException e) {
            this.tempFile.delete();
            throw new WriteException("Add row :" + row + " error", e);
        }
    }

    @Override
    public void setCell(int row, int col, String str) throws WriteException {
        throw new IllegalStateException("Not Support Yet");
    }

    private void setDimension(int row, int col) {
        if (col >= this.dimension.lastCol) {
            this.dimension.lastCol = col + 1;
        }
    }

    private void writeCommonStart() throws WriteException {
        this.writeRecord(this.factory.getSheetBOF());
        this.writeRecord(this.factory.getCalcMode());
        this.writeRecord(this.factory.getRefMode());
        this.writeRecord(this.factory.getIteration());
        this.writeRecord(this.factory.getDelta());
        this.writeRecord(this.factory.getSaveRecalc());
        this.writeRecord(this.factory.getPrintHeaders());
        this.writeRecord(this.factory.getGridSet());
        this.writeRecord(this.factory.getGuts());
        this.writeRecord(this.factory.getDefaultRowHeight());
        this.writeRecord(this.factory.getWsBool());
        this.writeRecord(this.factory.getHeader());
        this.writeRecord(this.factory.getFooter());
        this.writeRecord(this.factory.getHCenter());
        this.writeRecord(this.factory.getVCenter());
        this.writeRecord(this.factory.getSetup());
        this.writeRecord(this.factory.getDefColWidth());
    }

    private void writeCommonEnd() throws WriteException {
        this.writeRecord(this.factory.getWindow2());
        this.writeRecord(this.factory.getWeid1());
        this.writeRecord(this.factory.getButtonPropertySet());
        this.writeRecord(this.factory.getEOF());
    }

    private void writeDimension() throws WriteException {
        DimensionRecord dr = new DimensionRecord();
        this.dimension.lastRow = this.currentRow;
        dr.setFirstColumn(this.dimension.firstCol);
        dr.setFirstRow(this.dimension.firstRow);
        dr.setLastRow(this.dimension.lastRow);
        dr.setLastColumn(this.dimension.lastCol);
        this.writeRecord(dr);
    }

    private void writeCell() throws WriteException {
        BufferedInputStream bis = null;
        try {
            this.bos.flush();
            bis = new BufferedInputStream(new FileInputStream(this.tempFile));
            int BUFFER_SIZE = 512;
            byte[] buffer = new byte[512];
            int byteSize = 0;
            while ((byteSize = bis.read(buffer)) != -1) {
                if (byteSize == 512) {
                    this.workBookGlobalsStreamWriter.writeRecord(buffer);
                    continue;
                }
                byte[] bb = new byte[byteSize];
                System.arraycopy(buffer, 0, bb, 0, byteSize);
                this.workBookGlobalsStreamWriter.writeRecord(bb);
            }
        }
        catch (IOException e) {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.tempFile.delete();
            throw new WriteException(e);
        }
    }

    private void writeRecord(Record record) throws WriteException {
        this.workBookGlobalsStreamWriter.writeRecord(record);
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileSheetStreamWriter other = (FileSheetStreamWriter)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.dimension);
        return sb.toString();
    }
}

