/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.biff.write;

import edu.npu.fastexcel.biff.record.Record;
import edu.npu.fastexcel.biff.record.RecordFactory;
import edu.npu.fastexcel.biff.record.globals.BoundSheetRecord;
import edu.npu.fastexcel.biff.record.globals.SSTRecord;
import edu.npu.fastexcel.biff.write.DefaultSheetStreamWriter;
import edu.npu.fastexcel.biff.write.FileSheetStreamWriter;
import edu.npu.fastexcel.biff.write.SheetWriter;
import edu.npu.fastexcel.biff.write.StreamWriter;
import edu.npu.fastexcel.compound.io.WriteException;
import edu.npu.fastexcel.compound.io.Writer;
import java.util.ArrayList;

public class WorkBookGlobalsStreamWriter
implements StreamWriter {
    private static final int MAX_SHEET_NAME_LEN = 31;
    private static final char[] ILLEGAL_CHARACTERS_OF_SHEET_NAME = new char[]{'*', ':', '?', '\\'};
    private Writer writer;
    private SSTRecord sstRecord;
    private ArrayList<SheetWriter> sheetStreamWriters;
    private RecordFactory factory;

    public WorkBookGlobalsStreamWriter(Writer writer, RecordFactory factory) {
        this.writer = writer;
        this.factory = factory;
        this.sheetStreamWriters = new ArrayList();
        this.sstRecord = new SSTRecord();
    }

    public ArrayList<SheetWriter> getSheetStreamWriters() {
        return this.sheetStreamWriters;
    }

    public int addSharedString(String str) throws WriteException {
        return this.sstRecord.addString(str);
    }

    private void checkSheetName(String sheetName) throws WriteException {
        if (sheetName == null || sheetName.trim().equals("")) {
            throw new WriteException("Sheet name cannot be null.");
        }
        if ((sheetName = sheetName.trim()).length() > 31) {
            throw new WriteException("Sheet name's length should less than 31.");
        }
        if (sheetName.charAt(0) == '\'') {
            throw new WriteException("Sheet name cannot start with '");
        }
        for (int i = 0; i < ILLEGAL_CHARACTERS_OF_SHEET_NAME.length; ++i) {
            if (sheetName.indexOf(ILLEGAL_CHARACTERS_OF_SHEET_NAME[i]) == -1) continue;
            throw new WriteException("Sheet name cannot contain:" + ILLEGAL_CHARACTERS_OF_SHEET_NAME[i]);
        }
    }

    public SheetWriter addSheet(String sheetName, boolean stream) throws WriteException {
        SheetWriter sheetWriter;
        this.checkSheetName(sheetName);
        if (stream) {
            FileSheetStreamWriter ssw = new FileSheetStreamWriter(this, this.factory);
            ssw.setName(sheetName);
            ssw.setIndex(this.sheetStreamWriters.size());
            ssw.open();
            sheetWriter = ssw;
        } else {
            DefaultSheetStreamWriter ssw = new DefaultSheetStreamWriter(this, this.factory);
            ssw.setName(sheetName);
            ssw.setIndex(this.sheetStreamWriters.size());
            ssw.open();
            sheetWriter = ssw;
        }
        if (this.sheetStreamWriters.contains(sheetWriter)) {
            throw new WriteException("Sheet:" + sheetName + " already exists.");
        }
        this.sheetStreamWriters.add(sheetWriter);
        return sheetWriter;
    }

    @Override
    public void open() throws WriteException {
        this.writeCommonStart();
    }

    @Override
    public int position() throws WriteException {
        return this.writer.position();
    }

    @Override
    public void close() throws WriteException {
        int sheetPos = this.writer.position();
        this.writeSheets();
        this.writeSST();
        this.writeCommonEnd();
        for (int i = 0; i < this.sheetStreamWriters.size(); ++i) {
            StreamWriter sw = (StreamWriter)((Object)this.sheetStreamWriters.get(i));
            sw.flush();
            sw.close();
        }
        this.writer.seek(sheetPos);
        this.writeSheets();
        this.writer.close();
    }

    @Override
    public void flush() throws WriteException {
    }

    public void writeRecord(Record record) throws WriteException {
        this.writer.write(record.getBytes());
    }

    public void writeRecord(byte[] record) throws WriteException {
        this.writer.write(record);
    }

    private void writeSST() throws WriteException {
        byte[] bb;
        SSTRecord.ByteReader reader = this.sstRecord.getByteReader();
        while ((bb = reader.read()) != null) {
            this.writer.write(bb);
        }
    }

    private void writeCommonStart() throws WriteException {
        this.writer.write(this.factory.getGlobalsBOF().getBytes());
        this.writer.write(this.factory.getInterFaceHdr().getBytes());
        this.writer.write(this.factory.getMms().getBytes());
        this.writer.write(this.factory.getInterFaceEnd().getBytes());
        this.writer.write(this.factory.getDsf().getBytes());
        this.writer.write(this.factory.getTabId().getBytes());
        this.writer.write(this.factory.getButtonPropertySet().getBytes());
        this.writer.write(this.factory.getFngroupCount().getBytes());
        this.writer.write(this.factory.getWindowProtect().getBytes());
        this.writer.write(this.factory.getProtect().getBytes());
        this.writer.write(this.factory.getPassword().getBytes());
        this.writer.write(this.factory.getProt4Rev().getBytes());
        this.writer.write(this.factory.getWindow1().getBytes());
        this.writer.write(this.factory.getBackup().getBytes());
        this.writer.write(this.factory.getHideObj().getBytes());
        this.writer.write(this.factory.getDateMode1900().getBytes());
        this.writer.write(this.factory.getPrecision().getBytes());
        this.writer.write(this.factory.getRefreShall().getBytes());
        this.writer.write(this.factory.getBookbool().getBytes());
        this.writer.write(this.factory.getFormat().getBytes());
        this.writer.write(this.factory.getXF().getBytes());
        for (int i = 0; i < 2048; ++i) {
            this.writer.write(this.factory.getXF().getBytes());
        }
    }

    private void writeCommonEnd() throws WriteException {
        this.writeRecord(this.factory.getEOF());
        this.writeRecord(this.factory.getEOF());
        this.writeRecord(this.factory.getEOF());
        this.writeRecord(this.factory.getEOF());
    }

    private void writeSheets() throws WriteException {
        for (int i = 0; i < this.sheetStreamWriters.size(); ++i) {
            StreamWriter sw = (StreamWriter)((Object)this.sheetStreamWriters.get(i));
            SheetWriter sheetWriter = this.sheetStreamWriters.get(i);
            BoundSheetRecord bsr = new BoundSheetRecord();
            bsr.setName(sheetWriter.getName());
            bsr.setStreamPosition(sw.position());
            this.writer.write(bsr.getBytes());
        }
    }
}

