/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.common.util;

public class NumUtil {
    public static final int RK_MASK_BIT0 = 1;
    public static final int RK_MASK_BIT1 = 2;
    public static final int RK_MASK_OTHER = -4;

    public static double getRKValue(int number) {
        long rawNumber = number;
        double rvalue = 0.0;
        rvalue = (number & 2) == 2 ? (double)rawNumber : Double.longBitsToDouble((rawNumber >>= 2) << 34);
        if ((number & 1) == 1) {
            rvalue /= 100.0;
        }
        return rvalue;
    }

    public static int getInt(byte b1, byte b2) {
        int i1 = b1 & 0xFF;
        int i2 = b2 & 0xFF;
        int val = i2 << 8 | i1;
        return val;
    }

    public static int getInt(byte b1, byte b2, byte b3, byte b4) {
        int i1 = NumUtil.getInt(b1, b2);
        int i2 = NumUtil.getInt(b3, b4);
        int val = i2 << 16 | i1;
        return val;
    }

    public static void getTwoBytes(int i, byte[] b) {
        b[0] = (byte)(i & 0xFF);
        b[1] = (byte)((i & 0xFF00) >> 8);
    }

    public static byte[] getFourBytes(int i) {
        byte[] bytes = new byte[4];
        int i1 = i & 0xFFFF;
        int i2 = (i & 0xFFFF0000) >> 16;
        NumUtil.getTwoBytes(i1, bytes, 0);
        NumUtil.getTwoBytes(i2, bytes, 2);
        return bytes;
    }

    public static void getTwoBytes(int i, byte[] target, int pos) {
        target[pos] = (byte)(i & 0xFF);
        target[pos + 1] = (byte)((i & 0xFF00) >> 8);
    }

    public static void getFourBytes(int i, byte[] target, int pos) {
        byte[] bytes = NumUtil.getFourBytes(i);
        target[pos] = bytes[0];
        target[pos + 1] = bytes[1];
        target[pos + 2] = bytes[2];
        target[pos + 3] = bytes[3];
    }

    public static void fill(byte b, byte[] target, int pos, int len) {
        for (int i = 0; i < len; ++i) {
            target[pos + i] = b;
        }
    }

    public static double getIEEEDouble(byte[] data, int pos) {
        int num1 = NumUtil.getInt(data[pos], data[pos + 1], data[pos + 2], data[pos + 3]);
        int num2 = NumUtil.getInt(data[pos + 4], data[pos + 5], data[pos + 6], data[pos + 7]);
        boolean negative = (num2 & Integer.MIN_VALUE) != 0;
        long val = (long)(num2 & Integer.MAX_VALUE) * 0x100000000L + (num1 < 0 ? 0x100000000L + (long)num1 : (long)num1);
        double value = Double.longBitsToDouble(val);
        if (negative) {
            value = -value;
        }
        return value;
    }
}

