/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.common.util;

import edu.npu.fastexcel.common.util.NumUtil;
import java.io.UnsupportedEncodingException;

public final class StringUtil {
    public static final String UNICODE_ENCODING = "UnicodeLittle";
    public static final int STRING_MASK_CCOMPR = 1;
    public static final int STRING_MASK_PHONETIC = 4;
    public static final int STRING_MASK_RICHTEXT = 8;

    private StringUtil() {
    }

    public static String getASCIIString(byte[] bytes, int offset, int len) {
        String s = new String(bytes, offset, len);
        return s;
    }

    public static String getUnicodeString(byte[] bytes, int offset, int len) {
        try {
            return new String(bytes, offset, len * 2, UNICODE_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static byte[] getBIFFBytes(String str) {
        int ln = str.length();
        byte f = 1;
        byte[] bb = StringUtil.getUnicodeBytes(str);
        byte[] b = new byte[3 + bb.length];
        NumUtil.getTwoBytes(ln, b, 0);
        b[2] = f;
        System.arraycopy(bb, 0, b, 3, bb.length);
        return b;
    }

    public static int getBIFFUnicodeString(byte[] b, int offset, StringBuffer sb) {
        int from = offset;
        int ln = NumUtil.getInt(b[offset], b[offset + 1]);
        byte f = b[offset + 2];
        offset += 3;
        boolean ccompr = (f & 1) == 0;
        boolean phonetic = (f & 4) == 0;
        boolean richtext = (f & 8) == 0;
        int incr = 0;
        int rt = 0;
        int sz = 0;
        String name = "";
        if (!richtext) {
            rt = NumUtil.getInt(b[offset], b[offset + 1]);
            incr += 2;
        }
        if (!phonetic) {
            sz = NumUtil.getInt(b[offset + incr], b[offset + incr + 1], b[offset + incr + 2], b[offset + incr + 3]);
            incr += 4;
        }
        name = !ccompr ? StringUtil.getUnicodeString(b, offset, ln) : StringUtil.getASCIIString(b, offset += incr, ln);
        if (!richtext) {
            offset += rt * 4;
        }
        if (!phonetic) {
            offset += sz;
        }
        sb.append(name);
        return offset - from;
    }

    public static String getString(byte[] b, int offset) {
        byte len = b[offset];
        byte f = b[offset + 1];
        String name = f == 0 ? StringUtil.getASCIIString(b, offset + 2, len) : StringUtil.getUnicodeString(b, offset + 2, len);
        return name;
    }

    public static String join(int[] s) {
        if (s == null) {
            return "{null}";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < s.length; ++i) {
            if (i % 16 == 0 && i != 0) {
                sb.append("\n");
            }
            sb.append(s[i] + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    public static String join(Object[] s) {
        if (s == null) {
            return "{null}";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < s.length; ++i) {
            sb.append(s[i] + ",\n");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    public static String join(String[] s) {
        if (s == null) {
            return "null";
        }
        if (s.length == 0) {
            return "{}";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < s.length; ++i) {
            sb.append(s[i] + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    public static String join(byte[] s) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < s.length; ++i) {
            if (i % 16 == 0 && i != 0) {
                sb.append("\n");
            }
            sb.append(s[i] + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    public static String joinHex(byte[] s) {
        StringBuffer sb = new StringBuffer();
        String ss = "";
        sb.append("{");
        for (int i = 0; i < s.length; ++i) {
            if (i % 16 == 0 && i != 0) {
                sb.append("\n");
            }
            ss = "0" + Integer.toHexString(s[i]);
            sb.append(ss.substring(ss.length() - 2) + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    public static String dumpBytes(byte[] bb) {
        StringBuffer result = new StringBuffer(bb.length * 4);
        int c = 8;
        int lineCount = bb.length / c;
        int t = bb.length % c;
        if (t != 0) {
            ++lineCount;
        }
        for (int i = 0; i < lineCount; ++i) {
            result.append(i * c + "\t:");
            int tt = c;
            if (t != 0 && i == lineCount - 1) {
                tt = t;
            }
            char[] cc = new char[tt];
            for (int j = 0; j < tt; ++j) {
                String ss = "0" + Integer.toHexString(bb[i * c + j]);
                result.append(ss.substring(ss.length() - 2) + ",");
                cc[j] = (char)bb[i * c + j];
            }
            for (int k = 0; k < c - tt; ++k) {
                result.append("--,");
            }
            result.append("\t:");
            result.append(cc);
            result.append("\n");
        }
        return result.toString();
    }

    public static String fill(String s, int count) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static byte[] getBytes(String s) {
        return s.getBytes();
    }

    public static int getBytes(String s, byte[] bytes, int offset) {
        byte[] bb = StringUtil.getBytes(s);
        System.arraycopy(bb, 0, bytes, offset, bb.length);
        return bb.length;
    }

    public static byte[] getUnicodeBytes(String s) {
        try {
            byte[] b = s.getBytes(UNICODE_ENCODING);
            if (b.length == s.length() * 2 + 2) {
                byte[] b2 = new byte[b.length - 2];
                System.arraycopy(b, 2, b2, 0, b2.length);
                b = b2;
            }
            return b;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static int getUnicodeBytes(String s, byte[] bytes, int offset) {
        byte[] bb = StringUtil.getUnicodeBytes(s);
        System.arraycopy(bb, 0, bytes, offset, bb.length);
        return bb.length;
    }
}

