/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.compound;

import edu.npu.fastexcel.common.util.NumUtil;
import edu.npu.fastexcel.common.util.StringUtil;
import edu.npu.fastexcel.compound.DirectoryEntry;
import edu.npu.fastexcel.compound.SectorStreamReader;
import edu.npu.fastexcel.compound.io.MappedIOReader;
import edu.npu.fastexcel.compound.io.ReadException;
import edu.npu.fastexcel.compound.io.Reader;
import edu.npu.fastexcel.compound.stream.ReadableStream;
import java.io.File;

public class CompoundFileReader {
    public static final int SID_FREE = -1;
    public static final int SID_EOC = -2;
    public static final int SID_SAT = -3;
    public static final int SID_MSAT = -4;
    protected static final byte[] MAGIC = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    public static final int HEADER_SIZE = 512;
    protected File file;
    protected Reader reader;
    protected byte[] header = new byte[512];
    protected int ssz;
    protected int sssz;
    protected int sectorsOfSAT;
    protected int firstDirSID;
    protected int minSizeOfStream;
    protected int firstSSATSID;
    protected int sectorsOfSSAT;
    protected int firstMSATSID;
    protected int sectorsOfMSAT;
    protected int[] msat;
    protected int[] sat;
    protected int[] ssat;
    private DirectoryEntry[] directoryEntries;
    private SectorStreamReader shortStreamReader;

    public CompoundFileReader(File file) {
        this.reader = new MappedIOReader(file);
    }

    public void open() throws ReadException {
        this.reader.open();
        this.readHeader();
        this.readMSAT();
        this.readSAT();
        this.readSSAT();
        this.readDir();
        this.readShortSteamContainer();
    }

    public void close() throws ReadException {
        this.reader.close();
    }

    private void readHeader() throws ReadException {
        this.reader.read(this.header);
        for (int i = 0; i < MAGIC.length; ++i) {
            if (this.header[i] == MAGIC[i]) continue;
            throw new ReadException("Bad File Format.");
        }
        this.ssz = NumUtil.getInt(this.header[30], this.header[31]);
        this.sssz = NumUtil.getInt(this.header[32], this.header[33]);
        this.sectorsOfSAT = NumUtil.getInt(this.header[44], this.header[45], this.header[46], this.header[47]);
        this.firstDirSID = NumUtil.getInt(this.header[48], this.header[49], this.header[50], this.header[51]);
        this.minSizeOfStream = NumUtil.getInt(this.header[56], this.header[57], this.header[58], this.header[59]);
        this.firstSSATSID = NumUtil.getInt(this.header[60], this.header[61], this.header[62], this.header[63]);
        this.sectorsOfSSAT = NumUtil.getInt(this.header[64], this.header[65], this.header[66], this.header[67]);
        this.firstMSATSID = NumUtil.getInt(this.header[68], this.header[69], this.header[70], this.header[71]);
        this.sectorsOfMSAT = NumUtil.getInt(this.header[72], this.header[73], this.header[74], this.header[75]);
    }

    public int getSectorSize() {
        return 1 << this.ssz;
    }

    public int getSizeOfShortSector() {
        return 1 << this.sssz;
    }

    private void readSAT() throws ReadException {
        int number = this.getSectorSize() / 4;
        this.sat = new int[this.sectorsOfSAT * number];
        int j = 0;
        for (int i = 0; i < this.sectorsOfSAT; ++i) {
            int sid = this.msat[i];
            byte[] b = this.readSector(sid);
            int start = 0;
            for (int k = 0; k < number; ++k) {
                this.sat[j++] = NumUtil.getInt(b[start], b[start + 1], b[start + 2], b[start + 3]);
                start += 4;
            }
        }
    }

    private void readSSAT() throws ReadException {
        int[] ssatChain = this.getSectorChain(this.firstSSATSID, false);
        if (ssatChain.length == 0) {
            return;
        }
        SectorStreamReader ss = new SectorStreamReader(this.reader, ssatChain, this.ssz);
        ss.open();
        byte[] bb = new byte[ssatChain.length * this.getSectorSize()];
        ss.read(bb);
        this.ssat = new int[bb.length / 4];
        for (int i = 0; i < bb.length / 4; ++i) {
            this.ssat[i] = NumUtil.getInt(bb[i << 2], bb[(i << 2) + 1], bb[(i << 2) + 2], bb[(i << 2) + 3]);
        }
        ss.close();
    }

    private int[] getSectorChain(int sid, boolean mini) {
        int[] at;
        int[] nArray = at = mini ? this.ssat : this.sat;
        if (sid == -2) {
            return new int[0];
        }
        int t = 0;
        int t2 = sid;
        do {
            ++t;
        } while ((t2 = at[t2]) != -2);
        int[] rr = new int[t];
        t = 0;
        t2 = sid;
        do {
            rr[t++] = t2;
        } while ((t2 = at[t2]) != -2);
        return rr;
    }

    private void readDir() throws ReadException {
        int[] dirchain = this.getSectorChain(this.firstDirSID, false);
        if (dirchain.length == 0) {
            throw new ReadException("can not find directory stream.");
        }
        SectorStreamReader dirStream = new SectorStreamReader(this.reader, dirchain, this.ssz);
        dirStream.open();
        byte[] bb = new byte[dirchain.length * this.getSectorSize()];
        dirStream.read(bb);
        int numberEntries = bb.length / 128;
        this.directoryEntries = new DirectoryEntry[numberEntries];
        for (int i = 0; i < numberEntries; ++i) {
            byte[] b = new byte[128];
            System.arraycopy(bb, i * 128, b, 0, 128);
            this.directoryEntries[i] = new DirectoryEntry(b);
        }
        dirStream.close();
    }

    private void readShortSteamContainer() throws ReadException {
        DirectoryEntry e = this.getDirectoryEntry("Root Entry");
        if (e == null) {
            throw new ReadException("Can not find Root Entry.");
        }
        int[] chain = this.getSectorChain(e.secID, false);
        this.shortStreamReader = new SectorStreamReader(this.reader, chain, this.ssz);
    }

    private void readMSAT() throws ReadException {
        int[] t;
        int msatSize = 109 + this.sectorsOfMSAT * this.getSectorSize() / 4;
        this.msat = new int[msatSize];
        int start = 76;
        for (int i = 0; i < 109; ++i) {
            this.msat[i] = NumUtil.getInt(this.header[start], this.header[start + 1], this.header[start + 2], this.header[start + 3]);
            start += 4;
        }
        int temp = this.firstMSATSID;
        int tt = 109;
        while ((t = this.readMSAT(temp)) != null) {
            System.arraycopy(t, 0, this.msat, tt, t.length - 1);
            tt += t.length - 1;
            temp = t[t.length - 1];
        }
    }

    private int[] readMSAT(int sid) throws ReadException {
        if (sid == -2) {
            return null;
        }
        int number = this.getSectorSize() / 4;
        byte[] b = this.readSector(sid);
        int[] ii = new int[number];
        int start = 0;
        for (int i = 0; i < number; ++i) {
            ii[i] = NumUtil.getInt(b[start], b[start + 1], b[start + 2], b[start + 3]);
            start += 4;
        }
        return ii;
    }

    private byte[] readSector(int sid) throws ReadException {
        byte[] b = new byte[512];
        this.reader.seek(this.getSectorPos(sid));
        this.reader.read(b);
        return b;
    }

    private final int getSectorPos(int sid) {
        return 512 + sid * this.getSectorSize();
    }

    protected SectorStreamReader getSectorStreamReader(String entryName) {
        DirectoryEntry e = this.getDirectoryEntry(entryName);
        if (e == null) {
            return null;
        }
        SectorStreamReader sc = this.isMiniSector(e.streamSize) ? new SectorStreamReader(this.shortStreamReader, this.getSectorChain(e.secID, true), this.sssz, 0) : new SectorStreamReader(this.reader, this.getSectorChain(e.secID, false), this.ssz);
        return sc;
    }

    private final boolean isMiniSector(int streamSize) {
        return streamSize < this.minSizeOfStream;
    }

    public DirectoryEntry getDirectoryEntry(String entryName) {
        for (int i = 0; i < this.directoryEntries.length; ++i) {
            if (!this.directoryEntries[i].name.equalsIgnoreCase(entryName)) continue;
            return this.directoryEntries[i];
        }
        return null;
    }

    public ReadableStream getReadableStream(String streamName) {
        SectorStreamReader sr = this.getSectorStreamReader(streamName);
        if (sr == null) {
            return null;
        }
        ReadableStream stream = new ReadableStream(streamName);
        stream.setReader(sr);
        DirectoryEntry de = this.getDirectoryEntry(streamName);
        stream.setType(de.type);
        stream.setSize(de.streamSize);
        return stream;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("ssz:" + this.ssz + ",");
        sb.append("sssz:" + this.sssz + ",");
        sb.append("sectorsOfSAT:" + this.sectorsOfSAT + ",");
        sb.append("firstDirSID:" + this.firstDirSID + ",");
        sb.append("minSizeOfStream:" + this.minSizeOfStream + ",");
        sb.append("firstSSATSID:" + this.firstSSATSID + ",");
        sb.append("sectorsOfSSAT:" + this.sectorsOfSSAT + ",");
        sb.append("firstMSATSID:" + this.firstMSATSID + ",");
        sb.append("sectorsOfMSAT:" + this.sectorsOfMSAT + ",");
        sb.append("\nMSAT:" + StringUtil.join(this.msat));
        sb.append("\nSAT:" + StringUtil.join(this.sat));
        sb.append("\nSSAT:" + StringUtil.join(this.ssat));
        sb.append("\nDIR:" + StringUtil.join(this.directoryEntries));
        sb.append("}");
        return sb.toString();
    }
}

