/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.compound;

import edu.npu.fastexcel.common.util.NumUtil;
import edu.npu.fastexcel.common.util.StringUtil;
import edu.npu.fastexcel.compound.DirectoryEntry;
import edu.npu.fastexcel.compound.SectorStreamWriter;
import edu.npu.fastexcel.compound.io.RandomAccessWriter;
import edu.npu.fastexcel.compound.io.WriteException;
import edu.npu.fastexcel.compound.io.Writer;
import java.io.File;

public class CompoundFileWriter {
    private static final int SID_FREE = -1;
    private static final byte[] FREE = NumUtil.getFourBytes(-1);
    private static final int SID_EOC = -2;
    private static final byte[] EOC = NumUtil.getFourBytes(-2);
    private static final int SID_SAT = -3;
    private static final int SID_MSAT = -4;
    private static final byte[] MAGIC = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    public static final int HEADER_SIZE = 512;
    private static final int FIRST_MSAT_POS = 76;
    private static final byte[] FREE512 = new byte[512];
    private static final byte[] ZERO512 = new byte[512];
    Writer writer;
    private byte[] header;
    protected int ssz;
    protected int sssz;
    private int minSizeOfStream;
    private int firstSSATSID;
    private int ssatCount;
    private int firstMSATSID;
    private int msatSectorCount = 0;
    private int firstDirSID;
    private int lastMSATSID;
    private int msatCount;
    private int lastSATSID;
    private int globalSectorIndex;
    protected int sidCountPreSector;
    private byte[] fourBytesHolder = new byte[4];
    private SectorStreamWriter dirStreamWriter;
    private DirectoryEntry[] directoryEntries;
    private int dirCount;
    private DirectoryEntry lastDir;
    int newMsatInSector = 0;
    private DirectoryEntry rootStorage;

    public CompoundFileWriter(File file) {
        this.writer = new RandomAccessWriter(file);
        this.firstDirSID = -2;
        this.firstMSATSID = -2;
        this.firstSSATSID = -2;
        this.msatCount = 0;
        this.msatSectorCount = 0;
        this.lastMSATSID = -1;
        this.lastSATSID = -1;
        this.globalSectorIndex = 0;
        this.ssz = 9;
        this.sssz = 6;
        this.sidCountPreSector = 1 << this.ssz - 2;
        this.rootStorage = new DirectoryEntry();
        this.rootStorage.name = "Root Entry";
        this.rootStorage.leftDID = -1;
        this.rootStorage.rightDID = -1;
        this.rootStorage.rootDID = 1;
        this.rootStorage.type = 5;
        this.rootStorage.color = 1;
        this.rootStorage.streamSize = 0;
        this.rootStorage.secID = -2;
        this.dirCount = 0;
        this.directoryEntries = new DirectoryEntry[32];
        this.directoryEntries[this.dirCount] = this.rootStorage;
        ++this.dirCount;
        this.dirStreamWriter = new SectorStreamWriter("dirwriter", this, this.ssz, null);
    }

    public void open() throws WriteException {
        this.writer.open();
        this.writeHeader();
        this.dirStreamWriter.open();
        this.writeRootStorage();
    }

    public void close() throws WriteException {
        this.writeAllDirectoryEntry();
        this.dirStreamWriter.close();
        this.updateHeader();
        this.writer.flush();
        this.writer.close();
    }

    public Writer createWriteableStream(String streamName) {
        DirectoryEntry e = new DirectoryEntry();
        e.id = this.dirCount++;
        e.name = streamName;
        e.color = 1;
        e.leftDID = -1;
        e.rightDID = -1;
        e.rootDID = -1;
        e.type = 2;
        this.directoryEntries[e.id] = e;
        if (this.lastDir == null) {
            this.lastDir = e;
        } else if (this.lastDir.leftDID == -1) {
            this.lastDir.leftDID = e.id;
            e.color = this.lastDir.color == 1 ? 0 : 1;
        } else if (this.lastDir.rightDID == -1) {
            this.lastDir.rightDID = e.id;
            e.color = this.lastDir.color == 1 ? 0 : 1;
            this.lastDir = e;
        }
        SectorStreamWriter w = new SectorStreamWriter(streamName + " ", this, this.ssz, e);
        return w;
    }

    final void allocSector(SectorStreamWriter w) throws WriteException {
        int next = this.globalSectorIndex;
        int satCount = this.msatCount * this.sidCountPreSector;
        int needChangeSATSID = -1;
        if (satCount <= next) {
            needChangeSATSID = this.lastSATSID;
            this.lastSATSID = this.globalSectorIndex++;
            this.writeMSAT(this.lastSATSID);
            this.writeSAT(this.lastSATSID, -3, this.lastSATSID);
        }
        next = this.globalSectorIndex++;
        this.writer.seek(this.getSectorPos(next));
        this.writer.write(ZERO512);
        if (w.sidChainEmpty()) {
            this.writeSAT(next, -2, this.lastSATSID);
            w.addSID(next);
        } else {
            int last = w.getLastSID();
            this.writeSAT(last, next, needChangeSATSID == -1 ? this.lastSATSID : needChangeSATSID);
            this.writeSAT(next, -2, this.lastSATSID);
            w.addSID(next);
        }
    }

    private final void writeSAT(int sid, int value, int satSID) throws WriteException {
        int off = this.getSectorPos(satSID);
        int t = sid % this.sidCountPreSector;
        NumUtil.getFourBytes(value, this.fourBytesHolder, 0);
        this.writer.seek(off += t * 4);
        this.writer.write(this.fourBytesHolder);
    }

    private final void writeMSAT(int sid) throws WriteException {
        if (this.msatCount < 109) {
            int off = 76 + this.msatCount * 4;
            NumUtil.getFourBytes(sid, this.fourBytesHolder, 0);
            this.writer.seek(off);
            this.writer.write(this.fourBytesHolder);
            this.writer.write(EOC);
        } else {
            if (this.firstMSATSID == -2) {
                this.firstMSATSID = this.lastMSATSID = this.globalSectorIndex++;
                this.newMsatInSector = 0;
                ++this.msatSectorCount;
                this.writeSAT(this.lastMSATSID, -4, this.lastSATSID);
                int it = this.getSectorPos(this.lastMSATSID);
                this.writer.seek(it);
                this.writer.write(FREE512);
            } else if (this.newMsatInSector == this.sidCountPreSector - 1) {
                int temp = this.lastMSATSID;
                this.lastMSATSID = this.globalSectorIndex++;
                this.newMsatInSector = 0;
                ++this.msatSectorCount;
                this.writeSAT(this.lastMSATSID, -4, this.lastSATSID);
                int pos = this.getSectorPos(temp);
                this.writer.seek(pos += (this.sidCountPreSector - 1) * 4);
                NumUtil.getFourBytes(this.lastMSATSID, this.fourBytesHolder, 0);
                this.writer.write(this.fourBytesHolder);
                int it = this.getSectorPos(this.lastMSATSID);
                this.writer.seek(it);
                this.writer.write(FREE512);
            }
            int pos = this.getSectorPos(this.lastMSATSID);
            ++this.newMsatInSector;
            this.writer.seek(pos += this.newMsatInSector * 4);
            NumUtil.getFourBytes(sid, this.fourBytesHolder, 0);
            this.writer.write(this.fourBytesHolder);
        }
        ++this.msatCount;
    }

    void sectorStreamClosed(SectorStreamWriter w) {
        if (w == this.dirStreamWriter) {
            this.firstDirSID = w.getFirstSID();
        }
    }

    final int nextGlobalSectorIndex() {
        return this.globalSectorIndex++;
    }

    final int getSectorPos(int sid) {
        return (sid << this.ssz) + 512;
    }

    private void writeRootStorage() throws WriteException {
        this.writeDirectoryEntry(this.rootStorage);
    }

    private void writeDirectoryEntry(DirectoryEntry e) throws WriteException {
        this.dirStreamWriter.seek(128 * e.id);
        this.dirStreamWriter.write(e.toBytes());
    }

    private void writeAllDirectoryEntry() throws WriteException {
        this.dirStreamWriter.seek(0);
        for (int i = 0; i < this.dirCount; ++i) {
            this.dirStreamWriter.write(this.directoryEntries[i].toBytes());
        }
    }

    private void updateHeader() throws WriteException {
        this.header = new byte[76];
        System.arraycopy(MAGIC, 0, this.header, 0, MAGIC.length);
        NumUtil.fill((byte)0, this.header, 8, 16);
        this.header[24] = 62;
        this.header[25] = 0;
        this.header[26] = 3;
        this.header[27] = 0;
        this.header[28] = -2;
        this.header[29] = -1;
        NumUtil.getTwoBytes(this.ssz, this.header, 30);
        NumUtil.getTwoBytes(this.sssz, this.header, 32);
        NumUtil.fill((byte)0, this.header, 34, 10);
        NumUtil.getFourBytes(this.msatCount, this.header, 44);
        NumUtil.getFourBytes(this.firstDirSID, this.header, 48);
        NumUtil.fill((byte)0, this.header, 52, 4);
        NumUtil.getFourBytes(this.minSizeOfStream, this.header, 56);
        NumUtil.getFourBytes(this.firstSSATSID, this.header, 60);
        NumUtil.getFourBytes(this.ssatCount, this.header, 64);
        NumUtil.getFourBytes(this.firstMSATSID, this.header, 68);
        NumUtil.getFourBytes(this.msatSectorCount, this.header, 72);
        this.writer.seek(0);
        this.writer.write(this.header);
    }

    private void writeHeader() throws WriteException {
        this.header = new byte[512];
        System.arraycopy(MAGIC, 0, this.header, 0, MAGIC.length);
        NumUtil.fill((byte)0, this.header, 8, 16);
        this.header[24] = 0;
        this.header[25] = 62;
        this.header[26] = 0;
        this.header[27] = 3;
        this.header[28] = -2;
        this.header[29] = -1;
        NumUtil.getTwoBytes(this.ssz, this.header, 30);
        NumUtil.getTwoBytes(this.sssz, this.header, 32);
        NumUtil.fill((byte)0, this.header, 34, 10);
        NumUtil.getFourBytes(this.msatCount, this.header, 44);
        NumUtil.getFourBytes(this.firstDirSID, this.header, 48);
        NumUtil.fill((byte)0, this.header, 52, 4);
        NumUtil.getFourBytes(this.minSizeOfStream, this.header, 56);
        NumUtil.getFourBytes(this.firstSSATSID, this.header, 60);
        NumUtil.getFourBytes(this.ssatCount, this.header, 64);
        NumUtil.getFourBytes(this.firstMSATSID, this.header, 68);
        NumUtil.getFourBytes(this.msatSectorCount, this.header, 72);
        int t = 76;
        for (int i = 0; i < 109; ++i) {
            this.header[t] = FREE[0];
            this.header[t + 1] = FREE[1];
            this.header[t + 2] = FREE[2];
            this.header[t + 3] = FREE[3];
            t += 4;
        }
        this.writer.seek(0);
        this.writer.write(this.header);
    }

    public static void main(String[] args) throws WriteException {
        CompoundFileWriter w = new CompoundFileWriter(new File("d:/test.xls"));
        w.open();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 5000; ++i) {
            String ss = StringUtil.fill("" + i, 512);
            sb.append(ss);
        }
        Writer sw = w.createWriteableStream("\u0005SummaryInformation");
        Writer sw2 = w.createWriteableStream("\u0005DocumentSummaryInformation");
        sw.open();
        sw.write(sb.toString().getBytes());
        sw.close();
        sw2.open();
        sw2.write(sb.toString().getBytes());
        sw2.close();
        w.close();
    }

    static {
        NumUtil.fill((byte)-1, FREE512, 0, 512);
        NumUtil.getFourBytes(-2, FREE512, 508);
    }
}

