/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.compound;

import edu.npu.fastexcel.common.util.NumUtil;
import edu.npu.fastexcel.common.util.StringUtil;

public class DirectoryEntry {
    public static final String ROOT_ENTRY_NAME = "Root Entry";
    public static final String WORKBOOK_NAME = "Workbook";
    public static final String WORKBOOK_NAME_OTHER = "Book";
    public static final String SUMMARY_INFORMATION_NAME = "\u0005SummaryInformation";
    public static final String DOCUMENT_SUMMARY_INFORMATION_NAME = "\u0005DocumentSummaryInformation";
    public static final int TYPE_ROOT_STORAGE = 5;
    public static final int TYPE_PROPERTY = 4;
    public static final int TYPE_LOCK_BYTES = 3;
    public static final int TYPE_USER_STREAM = 2;
    public static final int TYPE_USER_STORAGE = 1;
    public static final int TYPE_EMPTY = 0;
    public static final int COLOR_RED = 0;
    public static final int COLOR_BLACK = 1;
    public static final int DIR_LEN = 128;
    protected String name;
    protected int type;
    protected int color;
    protected int leftDID;
    protected int rightDID;
    protected int rootDID;
    protected int secID;
    protected int streamSize;
    protected byte[] bytes;
    protected int id;

    DirectoryEntry(byte[] b) {
        int nameLen = NumUtil.getInt(b[64], b[65]);
        this.name = StringUtil.getUnicodeString(b, 0, nameLen / 2);
        if (this.name.trim().length() == 0) {
            return;
        }
        this.name = this.name.substring(0, this.name.length() - 1);
        this.type = b[66];
        this.color = b[67];
        this.leftDID = NumUtil.getInt(b[68], b[69], b[70], b[71]);
        this.rightDID = NumUtil.getInt(b[72], b[73], b[74], b[75]);
        this.rootDID = NumUtil.getInt(b[76], b[77], b[78], b[79]);
        this.secID = NumUtil.getInt(b[116], b[117], b[118], b[119]);
        this.streamSize = NumUtil.getInt(b[120], b[121], b[122], b[123]);
        this.bytes = b;
    }

    public DirectoryEntry() {
        this.bytes = new byte[128];
    }

    public byte[] toBytes() {
        StringUtil.getUnicodeBytes(this.name, this.bytes, 0);
        NumUtil.getTwoBytes(this.name.length() * 2 + 2, this.bytes, 64);
        this.bytes[66] = (byte)this.type;
        this.bytes[67] = (byte)this.color;
        NumUtil.getFourBytes(this.leftDID, this.bytes, 68);
        NumUtil.getFourBytes(this.rightDID, this.bytes, 72);
        NumUtil.getFourBytes(this.rootDID, this.bytes, 76);
        NumUtil.getFourBytes(this.secID, this.bytes, 116);
        NumUtil.getFourBytes(this.streamSize, this.bytes, 120);
        return this.bytes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("name:" + this.name + ",");
        sb.append("type:" + this.type + ",");
        sb.append("color:" + this.color + ",");
        sb.append("leftDID:" + this.leftDID + ",");
        sb.append("rightDID:" + this.rightDID + ",");
        sb.append("rootDID:" + this.rootDID + ",");
        sb.append("shortStreamContainerSID:" + this.secID + ",");
        sb.append("shortStreamContainerSize:" + this.streamSize);
        sb.append("}");
        return sb.toString();
    }
}

