/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.compound;

import edu.npu.fastexcel.compound.io.ReadException;
import edu.npu.fastexcel.compound.io.Reader;

class SectorStreamReader
implements Reader {
    private Reader reader;
    private int[] sectorChain;
    private int position;
    private int length;
    private int sectorSize;
    private int ssz;
    private int offset;

    SectorStreamReader(Reader reader, int[] chain, int sectorSize, int offset) {
        this.sectorChain = chain;
        this.reader = reader;
        this.ssz = sectorSize;
        this.sectorSize = 1 << this.ssz;
        this.position = 0;
        this.offset = offset;
    }

    public SectorStreamReader(Reader reader, int[] chain, int sectorSize) {
        this(reader, chain, sectorSize, 512);
    }

    @Override
    public void close() throws ReadException {
    }

    @Override
    public long length() throws ReadException {
        return this.length;
    }

    @Override
    public void open() throws ReadException {
    }

    @Override
    public int position() throws ReadException {
        return this.position;
    }

    @Override
    public int read(byte[] b) throws ReadException {
        int p = this.position >> this.ssz;
        int off = this.position % this.sectorSize;
        int pos = 0;
        int p2 = 0;
        int len = 0;
        int chainLen = this.sectorChain.length;
        if (p >= chainLen) {
            return -1;
        }
        for (int byteLeft = b.length; byteLeft > 0 && p < chainLen; byteLeft -= len, ++p) {
            pos = this.offset + (this.sectorChain[p] << this.ssz) + off;
            len = this.sectorSize - off;
            len = len > byteLeft ? byteLeft : len;
            this.reader.seek(pos);
            this.reader.read(b, p2, len);
            p2 += len;
            off = 0;
        }
        this.position += b.length;
        return 0;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws ReadException {
        byte[] bb = new byte[length];
        this.read(bb);
        System.arraycopy(bb, 0, b, offset, length);
        return 0;
    }

    @Override
    public void seek(int pos) throws ReadException {
        this.position = pos;
    }

    @Override
    public byte read() throws ReadException {
        int p = this.position >> this.ssz;
        int off = this.position % this.sectorSize;
        int pos = 0;
        pos = this.offset + (this.sectorChain[p] << this.ssz) + off;
        this.reader.seek(pos);
        ++this.position;
        return this.reader.read();
    }
}

