/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.compound;

import edu.npu.fastexcel.compound.CompoundFileWriter;
import edu.npu.fastexcel.compound.DirectoryEntry;
import edu.npu.fastexcel.compound.io.WriteException;
import edu.npu.fastexcel.compound.io.Writer;

public class SectorStreamWriter
implements Writer {
    private int[] sectorChain = new int[1024];
    private int chainSize = 0;
    private CompoundFileWriter file;
    private Writer writer;
    private int sectorSize;
    private int ssz;
    private static final int ARRAY_GROW_SIZE = 1024;
    private int position;
    DirectoryEntry directoryEntry;

    final int getLastSID() {
        return this.sectorChain[this.chainSize - 1];
    }

    final int getFirstSID() {
        return this.sectorChain.length == 0 ? -1 : this.sectorChain[0];
    }

    final void addSID(int sid) {
        if (this.chainSize == this.sectorChain.length) {
            int[] newArray = new int[this.sectorChain.length + 1024];
            System.arraycopy(this.sectorChain, 0, newArray, 0, this.sectorChain.length);
            this.sectorChain = newArray;
        }
        this.sectorChain[this.chainSize++] = sid;
    }

    final boolean sidChainEmpty() {
        return this.chainSize == 0;
    }

    public SectorStreamWriter(String name, CompoundFileWriter file, int sectorSize, DirectoryEntry e) {
        this.file = file;
        this.writer = file.writer;
        this.position = 0;
        this.ssz = sectorSize;
        this.sectorSize = 1 << this.ssz;
        this.directoryEntry = e;
    }

    @Override
    public void close() throws WriteException {
        this.file.sectorStreamClosed(this);
        if (this.directoryEntry == null) {
            return;
        }
        this.directoryEntry.secID = this.getFirstSID();
        this.directoryEntry.streamSize = this.chainSize << this.ssz;
    }

    @Override
    public void flush() throws WriteException {
    }

    @Override
    public void open() throws WriteException {
        this.position = 0;
    }

    @Override
    public void seek(int pos) throws WriteException {
        this.position = pos;
    }

    @Override
    public void write(byte[] b) throws WriteException {
        int p = this.position >> this.ssz;
        int off = this.position % this.sectorSize;
        int byteLeft = b.length;
        int pos = 0;
        int p2 = 0;
        int len = 0;
        if (p == this.chainSize) {
            this.file.allocSector(this);
        }
        while (byteLeft > 0) {
            if (p == this.chainSize) {
                this.file.allocSector(this);
            }
            pos = 512 + (this.sectorChain[p] << this.ssz) + off;
            len = this.sectorSize - off;
            len = len > byteLeft ? byteLeft : len;
            this.writer.seek(pos);
            this.writer.write(b, p2, len);
            p2 += len;
            byteLeft -= len;
            off = 0;
            ++p;
        }
        this.position += b.length;
    }

    @Override
    public void write(byte[] b, int offset, int len) throws WriteException {
    }

    @Override
    public int position() {
        return this.position;
    }
}

