/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.compound;

import edu.npu.fastexcel.common.util.NumUtil;
import edu.npu.fastexcel.common.util.StringUtil;
import edu.npu.fastexcel.compound.CompoundFileReader;
import edu.npu.fastexcel.compound.io.ReadException;
import edu.npu.fastexcel.compound.io.Reader;
import edu.npu.fastexcel.compound.stream.ReadableStream;
import java.io.File;

public class SummaryInformation {
    private ReadableStream summaryInfoStream;
    private Reader reader;

    public SummaryInformation(CompoundFileReader file) {
        this.summaryInfoStream = file.getReadableStream("\u0005SummaryInformation");
        if (this.summaryInfoStream == null) {
            return;
        }
        this.reader = this.summaryInfoStream.getReader();
    }

    public void load() throws ReadException {
        int i;
        if (this.reader == null) {
            return;
        }
        this.reader.open();
        int length = this.summaryInfoStream.getSize();
        byte[] bb = new byte[length];
        this.reader.read(bb);
        int secCount = NumUtil.getInt(bb[24], bb[25], bb[26], bb[27]);
        int now = 28;
        int secLen = 20;
        int[] secs = new int[secCount];
        for (i = 0; i < secCount; ++i) {
            int secoff;
            secs[i] = secoff = NumUtil.getInt(bb[now + 16], bb[now + 17], bb[now + 18], bb[now + 19]);
            now += secLen;
        }
        for (i = 0; i < secs.length; ++i) {
            int off = secs[i];
            int propCount = NumUtil.getInt(bb[off + 4], bb[off + 5], bb[off + 6], bb[off + 7]);
            int n = off + 8;
            for (int j = 0; j < propCount; ++j) {
                int id = NumUtil.getInt(bb[n], bb[n + 1], bb[n + 2], bb[n + 3]);
                int offset = NumUtil.getInt(bb[n + 4], bb[n + 5], bb[n + 6], bb[n + 7]);
                n += 8;
                this.readProperty(bb, id, offset);
            }
        }
        this.reader.close();
    }

    private void readProperty(byte[] b, int id, int offset) {
        int type = NumUtil.getInt(b[offset], b[offset + 1], b[offset + 2], b[offset + 3]);
        System.err.println("----id:" + id + " type:" + type);
        switch (type) {
            case 2: {
                int value = NumUtil.getInt(b[offset + 4], b[offset + 5]);
                System.err.println(type + "," + value);
                break;
            }
            case 3: {
                int value = NumUtil.getInt(b[offset + 4], b[offset + 5], b[offset + 6], b[offset + 7]);
                System.err.println(type + "," + value);
                break;
            }
            case 19: {
                int value = NumUtil.getInt(b[offset + 4], b[offset + 5], b[offset + 6], b[offset + 7]);
                System.err.println(type + "," + value);
                break;
            }
            case 30: {
                int len = NumUtil.getInt(b[offset + 4], b[offset + 5], b[offset + 6], b[offset + 7]);
                String ss = StringUtil.getASCIIString(b, offset + 8, len);
                System.err.println(type + "," + ss);
                break;
            }
            case 64: {
                System.out.println("----time");
                break;
            }
            case 71: {
                break;
            }
        }
    }

    public static void main(String[] args) throws ReadException {
        CompoundFileReader file = new CompoundFileReader(new File("d:/aa.xls"));
        file.open();
        System.out.println(file);
        SummaryInformation information = new SummaryInformation(file);
        information.load();
    }
}

