/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.compound.io;

import edu.npu.fastexcel.compound.io.ReadException;
import edu.npu.fastexcel.compound.io.Reader;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Cleaner;

public class MappedIOReader
implements Reader {
    private File file;
    private RandomAccessFile raf;
    private FileChannel channel;
    private MappedByteBuffer mbb;

    public MappedIOReader(File file) {
        this.file = file;
    }

    @Override
    public void close() throws ReadException {
        try {
            this.channel.close();
            this.mbb.clear();
            this.raf.close();
            this.unmap(this.mbb);
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
        catch (Exception e) {
            throw new ReadException(e);
        }
    }

    public void unmap(final Object buffer) throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                    getCleanerMethod.setAccessible(true);
                    Cleaner cleaner = (Cleaner)getCleanerMethod.invoke(buffer, new Object[0]);
                    cleaner.clean();
                }
                catch (Exception e) {
                    System.err.println("can not unmap MappedByteBuffer," + e.getMessage());
                }
                return null;
            }
        });
    }

    @Override
    public int position() throws ReadException {
        return this.mbb.position();
    }

    @Override
    public void open() throws ReadException {
        try {
            this.raf = new RandomAccessFile(this.file, "r");
            this.channel = this.raf.getChannel();
            this.mbb = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.raf.length());
        }
        catch (IOException e) {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ReadException(e);
        }
    }

    @Override
    public void seek(int offset) throws ReadException {
        this.mbb.position(offset);
    }

    @Override
    public byte read() throws ReadException {
        return this.mbb.get();
    }

    @Override
    public int read(byte[] b) throws ReadException {
        this.mbb.get(b);
        return 1;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws ReadException {
        this.mbb.get(b, offset, length);
        return 1;
    }

    @Override
    public long length() throws ReadException {
        try {
            return this.raf.length();
        }
        catch (IOException e) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ReadException(e);
        }
    }
}

