/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.compound.io;

import edu.npu.fastexcel.compound.io.ReadException;
import edu.npu.fastexcel.compound.io.Reader;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessReader
implements Reader {
    private File file;
    private RandomAccessFile raf;

    public RandomAccessReader(File file) {
        this.file = file;
    }

    @Override
    public void close() throws ReadException {
        try {
            this.raf.close();
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
    }

    @Override
    public int position() throws ReadException {
        try {
            return (int)this.raf.getFilePointer();
        }
        catch (IOException e) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ReadException(e);
        }
    }

    @Override
    public void open() throws ReadException {
        try {
            this.raf = new RandomAccessFile(this.file, "r");
        }
        catch (IOException e) {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ReadException(e);
        }
    }

    @Override
    public void seek(int offset) throws ReadException {
        try {
            this.raf.seek(offset);
        }
        catch (IOException e) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ReadException(e);
        }
    }

    @Override
    public byte read() throws ReadException {
        try {
            return this.raf.readByte();
        }
        catch (IOException e) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ReadException(e);
        }
    }

    @Override
    public int read(byte[] b) throws ReadException {
        try {
            return this.raf.read(b);
        }
        catch (IOException e) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ReadException(e);
        }
    }

    @Override
    public int read(byte[] b, int offset, int length) throws ReadException {
        try {
            return this.raf.read(b, offset, length);
        }
        catch (IOException e) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ReadException(e);
        }
    }

    @Override
    public long length() throws ReadException {
        try {
            return this.raf.length();
        }
        catch (IOException e) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ReadException(e);
        }
    }
}

