/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.compound.io;

import edu.npu.fastexcel.compound.io.WriteException;
import edu.npu.fastexcel.compound.io.Writer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessWriter
implements Writer {
    private File file;
    private RandomAccessFile raf;

    public RandomAccessWriter(File file) {
        this.file = file;
    }

    @Override
    public void close() throws WriteException {
        try {
            this.raf.close();
        }
        catch (IOException e) {
            throw new WriteException(e);
        }
    }

    @Override
    public int position() throws WriteException {
        try {
            return (int)this.raf.getFilePointer();
        }
        catch (IOException e) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new WriteException(e);
        }
    }

    @Override
    public void open() throws WriteException {
        try {
            if (this.file.exists()) {
                this.file.delete();
            }
            this.raf = new RandomAccessFile(this.file, "rw");
        }
        catch (IOException e) {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new WriteException(e);
        }
    }

    @Override
    public void seek(int offset) throws WriteException {
        try {
            this.raf.seek(offset);
        }
        catch (IOException e) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new WriteException(e);
        }
    }

    @Override
    public void flush() throws WriteException {
    }

    @Override
    public void write(byte[] b) throws WriteException {
        try {
            this.raf.write(b);
        }
        catch (IOException e) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new WriteException(e);
        }
    }

    @Override
    public void write(byte[] b, int offset, int len) throws WriteException {
        try {
            this.raf.write(b, offset, len);
        }
        catch (IOException e) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new WriteException(e);
        }
    }
}

