/*
 * Decompiled with CFR 0.152.
 */
package edu.npu.fastexcel.dev;

import edu.npu.fastexcel.ExcelException;
import edu.npu.fastexcel.FastExcel;
import edu.npu.fastexcel.Sheet;
import edu.npu.fastexcel.Workbook;
import java.io.File;

public class ExcelDump {
    public static void main(String[] args) {
        String s;
        String option;
        if (args.length < 2) {
            ExcelDump.usage();
            System.exit(1);
        }
        if ((option = args[0]).equals("-d")) {
            s = args[1];
            if ((s = s.trim()).indexOf(64) == -1 || s.indexOf(64) == s.length() - 1) {
                ExcelDump.usage();
                System.exit(1);
            }
            String sheet = s.substring(0, s.indexOf(64));
            String file = s.substring(s.indexOf(64) + 1, s.length());
            int r = ExcelDump.dump(file, sheet);
            System.exit(r);
        }
        if (option.equals("-s")) {
            s = args[1];
            s = s.trim();
            int r = ExcelDump.dumpSheet(s);
            System.exit(r);
        }
    }

    public static int dumpSheet(String file) {
        File f = new File(file);
        if (!f.exists()) {
            System.err.println("Can not find this file:" + file);
            System.exit(-1);
        }
        Workbook wb = FastExcel.createReadableWorkbook(f);
        try {
            wb.open();
            String[] names = wb.sheetNames();
            for (int i = 0; i < names.length; ++i) {
                System.out.println(names[i]);
            }
            wb.close();
        }
        catch (ExcelException e) {
            System.err.println("Error:" + e.getMessage());
            return -1;
        }
        return 0;
    }

    public static int dump(String file, String sheet) {
        int r = 0;
        File f = new File(file);
        if (!f.exists()) {
            System.err.println("Can not find this file:" + file);
            System.exit(-1);
        }
        Workbook wb = FastExcel.createReadableWorkbook(f);
        try {
            wb.open();
            Sheet ss = wb.getSheet(sheet);
            if (ss == null) {
                System.err.println("Can not find this sheet:" + sheet);
                System.exit(-1);
            }
            int lastRow = ss.getLastRow();
            for (int i = ss.getFirstRow(); i <= lastRow; ++i) {
                String[] row = ss.getRow(i);
                if (row == null) {
                    System.out.println();
                    continue;
                }
                for (int j = 0; j < row.length; ++j) {
                    System.out.print(row[j] == null ? "" : row[j]);
                    if (j != row.length - 1) {
                        System.out.print(",");
                        continue;
                    }
                    System.out.println();
                }
            }
            wb.close();
        }
        catch (ExcelException e) {
            System.err.println("Error:" + e.getMessage());
            return -1;
        }
        return r;
    }

    public static void usage() {
        System.out.println("Usage:ExcelDump [-d sheet@file ][-s file]");
    }
}

