/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.common.codec;

import com.google.common.collect.ImmutableList;
import io.grpc.Codec;
import java.util.Collection;
import net.devh.boot.grpc.common.codec.CodecType;

public class GrpcCodecDefinition {
    public static final GrpcCodecDefinition GZIP_DEFINITION = new GrpcCodecDefinition((Codec)new Codec.Gzip(), true, CodecType.ALL);
    public static final GrpcCodecDefinition IDENTITY_DEFINITION = new GrpcCodecDefinition(Codec.Identity.NONE, false, CodecType.ALL);
    public static final Collection<GrpcCodecDefinition> DEFAULT_DEFINITIONS = ImmutableList.builder().add((Object)GZIP_DEFINITION).add((Object)IDENTITY_DEFINITION).build();
    private final Codec codec;
    private final boolean advertised;
    private final CodecType codecType;

    public GrpcCodecDefinition(Codec codec, boolean advertised, CodecType codecType) {
        this.codec = codec;
        this.advertised = advertised;
        this.codecType = codecType;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public boolean isAdvertised() {
        return this.advertised;
    }

    public CodecType getCodecType() {
        return this.codecType;
    }
}

