/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.javacc.parser.JavaCCErrors;

public class Options {
    protected static Map optionValues = null;
    private static Set cmdLineSetting = null;
    private static Set inputFileSetting = null;

    protected Options() {
    }

    protected static int intValue(String string) {
        return (Integer)optionValues.get(string);
    }

    protected static boolean booleanValue(String string) {
        return (Boolean)optionValues.get(string);
    }

    protected static String stringValue(String string) {
        return (String)optionValues.get(string);
    }

    public static void init() {
        optionValues = new HashMap();
        cmdLineSetting = new HashSet();
        inputFileSetting = new HashSet();
        optionValues.put("LOOKAHEAD", new Integer(1));
        optionValues.put("CHOICE_AMBIGUITY_CHECK", new Integer(2));
        optionValues.put("OTHER_AMBIGUITY_CHECK", new Integer(1));
        optionValues.put("STATIC", Boolean.TRUE);
        optionValues.put("DEBUG_PARSER", Boolean.FALSE);
        optionValues.put("DEBUG_LOOKAHEAD", Boolean.FALSE);
        optionValues.put("DEBUG_TOKEN_MANAGER", Boolean.FALSE);
        optionValues.put("ERROR_REPORTING", Boolean.TRUE);
        optionValues.put("JAVA_UNICODE_ESCAPE", Boolean.FALSE);
        optionValues.put("UNICODE_INPUT", Boolean.FALSE);
        optionValues.put("IGNORE_CASE", Boolean.FALSE);
        optionValues.put("USER_TOKEN_MANAGER", Boolean.FALSE);
        optionValues.put("USER_CHAR_STREAM", Boolean.FALSE);
        optionValues.put("BUILD_PARSER", Boolean.TRUE);
        optionValues.put("BUILD_TOKEN_MANAGER", Boolean.TRUE);
        optionValues.put("TOKEN_MANAGER_USES_PARSER", Boolean.FALSE);
        optionValues.put("SANITY_CHECK", Boolean.TRUE);
        optionValues.put("FORCE_LA_CHECK", Boolean.FALSE);
        optionValues.put("COMMON_TOKEN_ACTION", Boolean.FALSE);
        optionValues.put("CACHE_TOKENS", Boolean.FALSE);
        optionValues.put("KEEP_LINE_COLUMN", Boolean.TRUE);
        optionValues.put("OUTPUT_DIRECTORY", ".");
        optionValues.put("JDK_VERSION", "1.4");
    }

    public static boolean isOption(String string) {
        return string != null && string.length() > 1 && string.charAt(0) == '-';
    }

    public static void setInputFileOption(Object object, Object object2, String string, int n) {
        String string2 = string.toUpperCase();
        if (!optionValues.containsKey(string2)) {
            JavaCCErrors.warning(object, "Bad option name \"" + string + "\".  Option setting will be ignored.");
            return;
        }
        Object v = optionValues.get(string2);
        if (v != null) {
            if (!(v instanceof Integer) || n <= 0) {
                JavaCCErrors.warning(object2, "Bad option value \"" + n + "\" for \"" + string + "\".  Option setting will be ignored.");
                return;
            }
            if (inputFileSetting.contains(string2)) {
                JavaCCErrors.warning(object, "Duplicate option setting for \"" + string + "\" will be ignored.");
                return;
            }
            if (cmdLineSetting.contains(string2)) {
                if ((Integer)v != n) {
                    JavaCCErrors.warning(object, "Command line setting of \"" + string + "\" modifies option value in file.");
                }
                return;
            }
        }
        optionValues.put(string2, new Integer(n));
        inputFileSetting.add(string2);
    }

    public static void setInputFileOption(Object object, Object object2, String string, boolean bl) {
        String string2 = string.toUpperCase();
        if (!optionValues.containsKey(string2)) {
            JavaCCErrors.warning(object, "Bad option name \"" + string + "\".  Option setting will be ignored.");
            return;
        }
        Object v = optionValues.get(string2);
        if (v != null) {
            if (!(v instanceof Boolean)) {
                JavaCCErrors.warning(object2, "Bad option value \"" + bl + "\" for \"" + string + "\".  Option setting will be ignored.");
                return;
            }
            if (inputFileSetting.contains(string2)) {
                JavaCCErrors.warning(object, "Duplicate option setting for \"" + string + "\" will be ignored.");
                return;
            }
            if (cmdLineSetting.contains(string2)) {
                if ((Boolean)v != bl) {
                    JavaCCErrors.warning(object, "Command line setting of \"" + string + "\" modifies option value in file.");
                }
                return;
            }
        }
        optionValues.put(string2, bl ? Boolean.TRUE : Boolean.FALSE);
        inputFileSetting.add(string2);
    }

    public static void setInputFileOption(Object object, Object object2, String string, String string2) {
        String string3 = string.toUpperCase();
        if (!optionValues.containsKey(string3)) {
            JavaCCErrors.warning(object, "Bad option name \"" + string + "\".  Option setting will be ignored.");
            return;
        }
        Object v = optionValues.get(string3);
        if (v != null) {
            if (!(v instanceof String)) {
                JavaCCErrors.warning(object2, "Bad option value \"" + string2 + "\" for \"" + string + "\".  Option setting will be ignored.");
                return;
            }
            if (inputFileSetting.contains(string3)) {
                JavaCCErrors.warning(object, "Duplicate option setting for \"" + string + "\" will be ignored.");
                return;
            }
            if (cmdLineSetting.contains(string3)) {
                if (!v.equals(string2)) {
                    JavaCCErrors.warning(object, "Command line setting of \"" + string + "\" modifies option value in file.");
                }
                return;
            }
        }
        optionValues.put(string3, string2);
        inputFileSetting.add(string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setCmdLineOption(String string) {
        Object object;
        String string2;
        int n;
        String string3 = string.toUpperCase();
        for (n = 0; n < string3.length() && string3.charAt(n) != '=' && string3.charAt(n) != ':'; ++n) {
        }
        if (n < 2 || n >= string3.length() - 1) {
            if (n != string3.length()) {
                System.out.println("Warning: Bad option \"" + string + "\" will be ignored.");
                return;
            }
            if (string3.length() > 3 && string3.charAt(1) == 'N' && string3.charAt(2) == 'O') {
                string2 = string3.substring(3);
                object = Boolean.FALSE;
            } else {
                string2 = string3.substring(1);
                object = Boolean.TRUE;
            }
        } else {
            block17: {
                if (string3.substring(n + 1).equals("TRUE")) {
                    object = Boolean.TRUE;
                } else if (string3.substring(n + 1).equals("FALSE")) {
                    object = Boolean.FALSE;
                } else {
                    try {
                        int n2 = Integer.parseInt(string3.substring(n + 1));
                        if (n2 <= 0) {
                            System.out.println("Warning: Bad option value in \"" + string + "\" will be ignored.");
                            return;
                        }
                        object = new Integer(n2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        object = string.substring(n + 1);
                        if (string.length() <= n + 2 || string.charAt(n + 1) != '\"' || string.charAt(string.length() - 1) != '\"') break block17;
                        object = string.substring(n + 2, string.length() - 1);
                    }
                }
            }
            string2 = string3.substring(1, n);
        }
        if (!optionValues.containsKey(string2)) {
            System.out.println("Warning: Bad option \"" + string + "\" will be ignored.");
            return;
        }
        Object v = optionValues.get(string2);
        if (object.getClass() != v.getClass()) {
            System.out.println("Warning: Bad option value in \"" + string + "\" will be ignored.");
            return;
        }
        if (cmdLineSetting.contains(string2)) {
            System.out.println("Warning: Duplicate option setting \"" + string + "\" will be ignored.");
            return;
        }
        optionValues.put(string2, object);
        cmdLineSetting.add(string2);
    }

    public static void normalize() {
        if (Options.getDebugLookahead() && !Options.getDebugParser()) {
            if (cmdLineSetting.contains("DEBUG_PARSER") || inputFileSetting.contains("DEBUG_PARSER")) {
                JavaCCErrors.warning("True setting of option DEBUG_LOOKAHEAD overrides false setting of option DEBUG_PARSER.");
            }
            optionValues.put("DEBUG_PARSER", Boolean.TRUE);
        }
    }

    public static int getLookahead() {
        return Options.intValue("LOOKAHEAD");
    }

    public static int getChoiceAmbiguityCheck() {
        return Options.intValue("CHOICE_AMBIGUITY_CHECK");
    }

    public static int getOtherAmbiguityCheck() {
        return Options.intValue("OTHER_AMBIGUITY_CHECK");
    }

    public static boolean getStatic() {
        return Options.booleanValue("STATIC");
    }

    public static boolean getDebugParser() {
        return Options.booleanValue("DEBUG_PARSER");
    }

    public static boolean getDebugLookahead() {
        return Options.booleanValue("DEBUG_LOOKAHEAD");
    }

    public static boolean getDebugTokenManager() {
        return Options.booleanValue("DEBUG_TOKEN_MANAGER");
    }

    public static boolean getErrorReporting() {
        return Options.booleanValue("ERROR_REPORTING");
    }

    public static boolean getJavaUnicodeEscape() {
        return Options.booleanValue("JAVA_UNICODE_ESCAPE");
    }

    public static boolean getUnicodeInput() {
        return Options.booleanValue("UNICODE_INPUT");
    }

    public static boolean getIgnoreCase() {
        return Options.booleanValue("IGNORE_CASE");
    }

    public static boolean getUserTokenManager() {
        return Options.booleanValue("USER_TOKEN_MANAGER");
    }

    public static boolean getUserCharStream() {
        return Options.booleanValue("USER_CHAR_STREAM");
    }

    public static boolean getBuildParser() {
        return Options.booleanValue("BUILD_PARSER");
    }

    public static boolean getBuildTokenManager() {
        return Options.booleanValue("BUILD_TOKEN_MANAGER");
    }

    public static boolean getTokenManagerUsesParser() {
        return Options.booleanValue("TOKEN_MANAGER_USES_PARSER");
    }

    public static boolean getSanityCheck() {
        return Options.booleanValue("SANITY_CHECK");
    }

    public static boolean getForceLaCheck() {
        return Options.booleanValue("FORCE_LA_CHECK");
    }

    public static boolean getCommonTokenAction() {
        return Options.booleanValue("COMMON_TOKEN_ACTION");
    }

    public static boolean getCacheTokens() {
        return Options.booleanValue("CACHE_TOKENS");
    }

    public static boolean getKeepLineColumn() {
        return Options.booleanValue("KEEP_LINE_COLUMN");
    }

    public static String getJdkVersion() {
        return Options.stringValue("JDK_VERSION");
    }

    public static File getOutputDirectory() {
        return new File(Options.stringValue("OUTPUT_DIRECTORY"));
    }
}

