/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit;

import java.math.BigDecimal;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Options;

public class JsonAssert {
    private static final String FULL_JSON = "fullJson";
    private static final String ACTUAL = "actual";
    private static final String ROOT = "";
    private static Configuration configuration = Configuration.empty();

    private JsonAssert() {
    }

    public static void assertJsonEquals(Object expected, Object actual) {
        JsonAssert.assertJsonEquals(expected, actual, configuration);
    }

    public static void assertJsonEquals(Object expected, Object actual, Configuration configuration) {
        JsonAssert.assertJsonPartEquals(expected, actual, ROOT, configuration);
    }

    public static void assertJsonPartEquals(Object expected, Object fullJson, String path) {
        JsonAssert.assertJsonPartEquals(expected, fullJson, path, configuration);
    }

    public static void assertJsonPartEquals(Object expected, Object fullJson, String path, Configuration configuration) {
        Diff diff = Diff.create((Object)expected, (Object)fullJson, (String)FULL_JSON, (String)path, (Configuration)configuration);
        if (!diff.similar()) {
            JsonAssert.doFail(diff.toString());
        }
    }

    public static void assertJsonNotEquals(Object expected, Object fullJson) {
        JsonAssert.assertJsonNotEquals(expected, fullJson, configuration);
    }

    public static void assertJsonNotEquals(Object expected, Object fullJson, Configuration configuration) {
        JsonAssert.assertJsonPartNotEquals(expected, fullJson, ROOT, configuration);
    }

    public static void assertJsonPartNotEquals(Object expected, Object fullJson, String path) {
        JsonAssert.assertJsonPartNotEquals(expected, fullJson, path, configuration);
    }

    public static void assertJsonPartNotEquals(Object expected, Object fullJson, String path, Configuration configuration) {
        Diff diff = Diff.create((Object)expected, (Object)fullJson, (String)FULL_JSON, (String)path, (Configuration)configuration);
        if (diff.similar()) {
            if (ROOT.equals(path)) {
                JsonAssert.doFail("Expected different values but the values were equal.");
            } else {
                JsonAssert.doFail(String.format("Expected different values in node \"%s\" but the values were equal.", path));
            }
        }
    }

    public static void assertJsonStructureEquals(Object expected, Object actual) {
        Diff diff = Diff.create((Object)expected, (Object)actual, (String)ACTUAL, (String)ROOT, (Configuration)configuration.withOptions(Option.COMPARING_ONLY_STRUCTURE, new Option[0]));
        if (!diff.similar()) {
            JsonAssert.doFail(diff.differences());
        }
    }

    public static void assertJsonPartStructureEquals(Object expected, Object fullJson, String path) {
        Diff diff = Diff.create((Object)expected, (Object)fullJson, (String)FULL_JSON, (String)path, (Configuration)configuration.withOptions(Option.COMPARING_ONLY_STRUCTURE, new Option[0]));
        if (!diff.similar()) {
            JsonAssert.doFail(diff.differences());
        }
    }

    public static void assertJsonNodeAbsent(Object actual, String path) {
        if (JsonUtils.nodeExists((Object)actual, (String)path)) {
            JsonAssert.doFail("Node \"" + path + "\" is present.");
        }
    }

    public static void assertJsonNodePresent(Object actual, String path) {
        if (!JsonUtils.nodeExists((Object)actual, (String)path)) {
            JsonAssert.doFail("Node \"" + path + "\" is missing.");
        }
    }

    private static void doFail(String diffMessage) {
        throw new AssertionError((Object)diffMessage);
    }

    public static void setIgnorePlaceholder(String ignorePlaceholder) {
        configuration = configuration.withIgnorePlaceholder(ignorePlaceholder);
    }

    public static String getIgnorePlaceholder() {
        return configuration.getIgnorePlaceholder();
    }

    public static void setTolerance(BigDecimal numericComparisonTolerance) {
        configuration = configuration.withTolerance(numericComparisonTolerance);
    }

    public static void setTolerance(double numberComparisonTolerance) {
        configuration = configuration.withTolerance(numberComparisonTolerance);
    }

    public static BigDecimal getTolerance() {
        return configuration.getTolerance();
    }

    @Deprecated
    public static void setTreatNullAsAbsent(boolean treatNullAsAbsent) {
        configuration = treatNullAsAbsent ? configuration.withOptions(Option.TREATING_NULL_AS_ABSENT, new Option[0]) : configuration.withOptions(configuration.getOptions().without(Option.TREATING_NULL_AS_ABSENT));
    }

    @Deprecated
    public static boolean getTreatNullAsAbsent() {
        return configuration.getOptions().contains(Option.TREATING_NULL_AS_ABSENT);
    }

    public static void setOptions(Option firstOption, Option ... rest) {
        configuration = configuration.withOptions(Options.empty().with(firstOption, rest));
    }

    public static void resetOptions() {
        configuration = configuration.withOptions(Options.empty());
    }

    static Configuration getConfiguration() {
        return configuration;
    }

    public static Configuration withTolerance(double tolerance) {
        return Configuration.empty().withTolerance(tolerance);
    }

    public static Configuration withTolerance(BigDecimal tolerance) {
        return Configuration.empty().withTolerance(tolerance);
    }

    public static Configuration when(Option first, Option ... next) {
        return Configuration.empty().withOptions(first, next);
    }
}

