/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit;

import java.math.BigDecimal;
import net.javacrumbs.jsonunit.ConfigurableJsonMatcher;
import net.javacrumbs.jsonunit.JsonAssert;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Options;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonMatchers {
    public static <T> ConfigurableJsonMatcher<T> jsonEquals(Object expected) {
        return new JsonPartMatcher("", expected);
    }

    public static <T> ConfigurableJsonMatcher<T> jsonPartEquals(String path, Object expected) {
        return new JsonPartMatcher(path, expected);
    }

    public static <T> Matcher<T> jsonPartMatches(String path, Matcher<?> matcher) {
        return new MatcherApplyingMatcher(path, matcher);
    }

    public static ConfigurableJsonMatcher<String> jsonStringEquals(Object expected) {
        return JsonMatchers.jsonEquals(expected);
    }

    public static ConfigurableJsonMatcher<String> jsonStringPartEquals(String path, Object expected) {
        return JsonMatchers.jsonPartEquals(path, expected);
    }

    public static <T> ConfigurableJsonMatcher<T> jsonNodeAbsent(String path) {
        return new JsonNodeAbsenceMatcher(path);
    }

    public static <T> ConfigurableJsonMatcher<T> jsonNodePresent(String path) {
        return new JsonNodePresenceMatcher(path);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MatcherApplyingMatcher<T>
    extends BaseMatcher<T> {
        private final String path;
        private final Matcher<?> matcher;

        public MatcherApplyingMatcher(String path, Matcher<?> matcher) {
            this.path = path;
            this.matcher = matcher;
        }

        public boolean matches(Object item) {
            Node node = JsonUtils.getNode((Object)item, (String)this.path);
            if (!node.isMissingNode()) {
                return this.matcher.matches(node.getValue());
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("node \"" + this.path + "\" ");
            this.matcher.describeTo(description);
        }

        public void describeMismatch(Object item, Description description) {
            Node node = JsonUtils.getNode((Object)item, (String)this.path);
            if (!node.isMissingNode()) {
                super.describeMismatch(node.getValue(), description);
            } else {
                description.appendText("Node \"" + this.path + "\" is missing.");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonNodePresenceMatcher<T>
    extends AbstractJsonMatcher<T> {
        JsonNodePresenceMatcher(String path) {
            super(path);
        }

        public boolean matches(Object item) {
            return JsonUtils.nodeExists((Object)item, (String)this.path);
        }

        public void describeTo(Description description) {
            description.appendText("Node \"" + this.path + "\" is present.");
        }

        public void describeMismatch(Object item, Description description) {
            description.appendText("Node \"" + this.path + "\" is missing.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonNodeAbsenceMatcher<T>
    extends AbstractJsonMatcher<T> {
        JsonNodeAbsenceMatcher(String path) {
            super(path);
        }

        public boolean matches(Object item) {
            return !JsonUtils.nodeExists((Object)item, (String)this.path);
        }

        public void describeTo(Description description) {
            description.appendText("Node \"" + this.path + "\" is absent.");
        }

        public void describeMismatch(Object item, Description description) {
            description.appendText("Node \"" + this.path + "\" is \"" + JsonUtils.getNode((Object)item, (String)this.path) + "\".");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonPartMatcher<T>
    extends AbstractJsonMatcher<T> {
        private final Object expected;
        private String differences;

        JsonPartMatcher(String path, Object expected) {
            super(path);
            this.expected = expected;
        }

        public boolean matches(Object item) {
            Diff diff = Diff.create((Object)this.expected, (Object)item, (String)"fullJson", (String)this.path, (Configuration)this.configuration);
            if (!diff.similar()) {
                this.differences = diff.differences();
            }
            return diff.similar();
        }

        public void describeTo(Description description) {
            if ("".equals(this.path)) {
                description.appendText(this.safeToString());
            } else {
                description.appendText(this.safeToString()).appendText(" in \"").appendText(this.path).appendText("\"");
            }
        }

        private String safeToString() {
            return this.expected != null ? this.expected.toString() : "null";
        }

        public void describeMismatch(Object item, Description description) {
            description.appendText(this.differences);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractJsonMatcher<T>
    extends BaseMatcher<T>
    implements ConfigurableJsonMatcher<T> {
        protected final String path;
        protected Configuration configuration = JsonAssert.getConfiguration();

        public AbstractJsonMatcher(String path) {
            this.path = path;
        }

        @Override
        public ConfigurableJsonMatcher<T> withTolerance(BigDecimal tolerance) {
            this.configuration = this.configuration.withTolerance(tolerance);
            return this;
        }

        @Override
        public ConfigurableJsonMatcher<T> withTolerance(double tolerance) {
            this.configuration = this.configuration.withTolerance(tolerance);
            return this;
        }

        @Override
        public ConfigurableJsonMatcher<T> when(Option first, Option ... next) {
            this.configuration = this.configuration.withOptions(first, next);
            return this;
        }

        @Override
        public ConfigurableJsonMatcher<T> withOptions(Options options) {
            this.configuration = this.configuration.withOptions(options);
            return this;
        }
    }
}

