/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit;

import java.math.BigDecimal;
import java.util.IdentityHashMap;
import java.util.Map;
import net.javacrumbs.jsonunit.ConfigurableJsonMatcher;
import net.javacrumbs.jsonunit.JsonAssert;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.ConfigurationWhen;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Options;
import net.javacrumbs.jsonunit.core.internal.Path;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class JsonMatchers {
    private static final String EMPTY_PATH = "";
    private static final String FULL_JSON = "fullJson";

    public static <T> ConfigurableJsonMatcher<T> jsonEquals(Object expected) {
        return new JsonPartMatcher(EMPTY_PATH, expected);
    }

    public static <T> ConfigurableJsonMatcher<T> jsonPartEquals(String path, Object expected) {
        return new JsonPartMatcher(path, expected);
    }

    public static <T> Matcher<T> jsonPartMatches(String path, Matcher<?> matcher) {
        return new MatcherApplyingMatcher(path, matcher);
    }

    public static ConfigurableJsonMatcher<String> jsonStringEquals(Object expected) {
        return JsonMatchers.jsonEquals(expected);
    }

    public static ConfigurableJsonMatcher<String> jsonStringPartEquals(String path, Object expected) {
        return JsonMatchers.jsonPartEquals(path, expected);
    }

    public static <T> ConfigurableJsonMatcher<T> jsonNodeAbsent(String path) {
        return new JsonNodeAbsenceMatcher(path);
    }

    public static <T> ConfigurableJsonMatcher<T> jsonNodePresent(String path) {
        return new JsonNodePresenceMatcher(path);
    }

    private static final class JsonPartMatcher<T>
    extends AbstractJsonMatcher<T> {
        private static final String HAMCREST_DIFFERENCE_STRING = "expected <%s> but was <%s>";
        private final Object expected;
        private final Map<Object, String> differences = new IdentityHashMap<Object, String>();

        JsonPartMatcher(String path, Object expected) {
            super(path);
            this.expected = expected;
        }

        @Override
        boolean doMatch(Object item) {
            Diff diff = Diff.createInternal((Object)this.expected, (Object)item, (String)JsonMatchers.FULL_JSON, (Path)Path.create((String)this.path, (String)JsonMatchers.EMPTY_PATH), (Configuration)this.configuration, (String)HAMCREST_DIFFERENCE_STRING);
            if (!diff.similar()) {
                this.differences.put(item, diff.differences());
            }
            return diff.similar();
        }

        public void describeTo(Description description) {
            if (JsonMatchers.EMPTY_PATH.equals(this.path)) {
                description.appendText(this.safeToString());
            } else {
                description.appendText(this.safeToString()).appendText(" in \"").appendText(this.path).appendText("\"");
            }
        }

        private String safeToString() {
            return this.expected != null ? this.expected.toString() : "null";
        }

        public void describeMismatch(Object item, Description description) {
            description.appendText(this.getDifference(item));
        }

        private String getDifference(Object item) {
            if (this.differences.size() == 1) {
                return this.differences.values().iterator().next();
            }
            return this.differences.get(item);
        }
    }

    private static final class MatcherApplyingMatcher<T>
    extends AbstractMatcher<T> {
        private final Matcher<?> matcher;

        MatcherApplyingMatcher(String path, Matcher<?> matcher) {
            super(path);
            this.matcher = matcher;
        }

        @Override
        boolean doMatch(Object item) {
            Node node = JsonUtils.getNode((Object)item, (String)this.path);
            if (!node.isMissingNode()) {
                return this.matcher.matches(node.getValue());
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("node \"" + this.getPath() + "\" ");
            this.matcher.describeTo(description);
        }

        public void describeMismatch(Object item, Description description) {
            Node node = JsonUtils.getNode((Object)item, (String)this.path);
            if (!node.isMissingNode()) {
                super.describeMismatch(node.getValue(), description);
            } else {
                description.appendText("Node \"" + this.getPath() + "\" is missing.");
            }
        }
    }

    private static final class JsonNodeAbsenceMatcher<T>
    extends AbstractJsonMatcher<T> {
        JsonNodeAbsenceMatcher(String path) {
            super(path);
        }

        @Override
        boolean doMatch(Object item) {
            return JsonUtils.nodeAbsent((Object)item, (String)this.path, (Configuration)this.configuration);
        }

        public void describeTo(Description description) {
            description.appendText("Node \"" + this.getPath() + "\" is absent.");
        }

        public void describeMismatch(Object item, Description description) {
            description.appendText("Node \"" + this.getPath() + "\" is \"" + JsonUtils.getNode((Object)item, (String)this.path) + "\".");
        }
    }

    private static final class JsonNodePresenceMatcher<T>
    extends AbstractJsonMatcher<T> {
        JsonNodePresenceMatcher(String path) {
            super(path);
        }

        @Override
        boolean doMatch(Object item) {
            return !JsonUtils.nodeAbsent((Object)item, (Path)this.getPath(), (Configuration)this.configuration);
        }

        public void describeTo(Description description) {
            description.appendText("Node \"" + this.getPath() + "\" is present.");
        }

        public void describeMismatch(Object item, Description description) {
            description.appendText("Node \"" + this.getPath() + "\" is missing.");
        }
    }

    private static abstract class AbstractJsonMatcher<T>
    extends AbstractMatcher<T>
    implements ConfigurableJsonMatcher<T> {
        Configuration configuration = JsonAssert.getConfiguration();

        AbstractJsonMatcher(String path) {
            super(path);
        }

        @Override
        public ConfigurableJsonMatcher<T> withTolerance(BigDecimal tolerance) {
            this.configuration = this.configuration.withTolerance(tolerance);
            return this;
        }

        @Override
        public ConfigurableJsonMatcher<T> withTolerance(double tolerance) {
            this.configuration = this.configuration.withTolerance(tolerance);
            return this;
        }

        @Override
        public ConfigurableJsonMatcher<T> when(Option first, Option ... next) {
            this.configuration = this.configuration.withOptions(first, next);
            return this;
        }

        @Override
        public ConfigurableJsonMatcher<T> withOptions(Options options) {
            this.configuration = this.configuration.withOptions(options);
            return this;
        }

        @Override
        public final ConfigurableJsonMatcher<T> when(ConfigurationWhen.PathsParam object, ConfigurationWhen.ApplicableForPath ... actions) {
            this.configuration = this.configuration.when(object, actions);
            return this;
        }

        @Override
        public ConfigurableJsonMatcher<T> withMatcher(String matcherName, Matcher<?> matcher) {
            this.configuration = this.configuration.withMatcher(matcherName, matcher);
            return this;
        }

        @Override
        public ConfigurableJsonMatcher<T> whenIgnoringPaths(String ... paths) {
            this.configuration = this.configuration.whenIgnoringPaths(paths);
            return this;
        }

        @Override
        public ConfigurableJsonMatcher<T> withDifferenceListener(DifferenceListener differenceListener) {
            this.configuration = this.configuration.withDifferenceListener(differenceListener);
            return this;
        }
    }

    private static abstract class AbstractMatcher<T>
    extends BaseMatcher<T> {
        final String path;
        Object actual;

        AbstractMatcher(String path) {
            this.path = path;
        }

        public final boolean matches(Object item) {
            this.actual = item;
            return this.doMatch(item);
        }

        abstract boolean doMatch(Object var1);

        Path getPath() {
            return Path.create((String)this.path, (String)JsonUtils.getPathPrefix((Object)this.actual));
        }
    }
}

