/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.classic.pattern.Abbreviator;
import ch.qos.logback.classic.pattern.ClassNameOnlyAbbreviator;
import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import net.logstash.logback.CachingAbbreviator;
import net.logstash.logback.NullAbbreviator;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.JsonWritingUtils;
import net.logstash.logback.fieldnames.LogstashFieldNames;

public class LoggerNameJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    public static final String FIELD_LOGGER_NAME = "logger_name";
    private int shortenedLoggerNameLength = -1;
    private Abbreviator abbreviator = NullAbbreviator.INSTANCE;

    public LoggerNameJsonProvider() {
        this.setFieldName(FIELD_LOGGER_NAME);
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        JsonWritingUtils.writeStringField(generator, this.getFieldName(), this.abbreviator.abbreviate(event.getLoggerName()));
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getLogger());
    }

    public int getShortenedLoggerNameLength() {
        return this.shortenedLoggerNameLength;
    }

    public void setShortenedLoggerNameLength(int length) {
        this.shortenedLoggerNameLength = length;
    }

    @Override
    public void start() {
        this.abbreviator = this.createAbbreviator();
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.abbreviator = null;
    }

    protected Abbreviator createAbbreviator() {
        if (this.shortenedLoggerNameLength < 0) {
            return NullAbbreviator.INSTANCE;
        }
        Object abbreviator = this.shortenedLoggerNameLength == 0 ? new ClassNameOnlyAbbreviator() : new TargetLengthBasedClassNameAbbreviator(this.shortenedLoggerNameLength);
        return new CachingAbbreviator((Abbreviator)abbreviator);
    }
}

