/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.List;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.loggingevent.LogstashMarkersJsonProvider;
import net.logstash.logback.fieldnames.LogstashFieldNames;
import net.logstash.logback.util.LogbackUtils;
import org.slf4j.Marker;

public class TagsJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    public static final String FIELD_TAGS = "tags";

    public TagsJsonProvider() {
        this.setFieldName(FIELD_TAGS);
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        boolean hasWrittenStart = false;
        hasWrittenStart = LogbackUtils.isVersion13() ? this.writeTagIfNecessary(generator, hasWrittenStart, event.getMarkerList()) : this.writeTagIfNecessary(generator, hasWrittenStart, event.getMarker());
        if (hasWrittenStart) {
            generator.writeEndArray();
        }
    }

    private boolean writeTagIfNecessary(JsonGenerator generator, boolean hasWrittenStart, List<Marker> markers) throws IOException {
        if (markers != null) {
            for (Marker marker : markers) {
                hasWrittenStart |= this.writeTagIfNecessary(generator, hasWrittenStart, marker);
            }
        }
        return hasWrittenStart;
    }

    private boolean writeTagIfNecessary(JsonGenerator generator, boolean hasWrittenStart, Marker marker) throws IOException {
        if (marker != null) {
            if (!LogstashMarkersJsonProvider.isLogstashMarker(marker)) {
                if (!hasWrittenStart) {
                    generator.writeArrayFieldStart(this.getFieldName());
                    hasWrittenStart = true;
                }
                generator.writeString(marker.getName());
            }
            if (marker.hasReferences()) {
                for (Marker next : marker) {
                    hasWrittenStart |= this.writeTagIfNecessary(generator, hasWrittenStart, next);
                }
            }
        }
        return hasWrittenStart;
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getTags());
    }
}

