/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;

public abstract class LogbackUtils {
    private static final boolean IS_VERSION_13 = LogbackUtils.hasMethod(LoggerContext.class, "getSequenceNumberGenerator", new Class[0]);

    private LogbackUtils() {
    }

    private static boolean hasMethod(Class<?> clazz, String name, Class<?> ... args) {
        try {
            return clazz.getMethod(name, args) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static boolean isVersion13() {
        return IS_VERSION_13;
    }

    public static void start(Object component) {
        if (component instanceof LifeCycle) {
            ((LifeCycle)component).start();
        }
    }

    public static void stop(Object component) {
        if (component instanceof LifeCycle) {
            ((LifeCycle)component).stop();
        }
    }

    public static void setContext(Context context, Object component) {
        if (component instanceof ContextAware) {
            ((ContextAware)component).setContext(context);
        }
    }

    public static void start(Context context, Object component) {
        LogbackUtils.setContext(context, component);
        LogbackUtils.start(component);
    }
}

