/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.joda;

import net.objectlab.kit.datecalc.common.BaseCalculator;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.NonWorkingDayChecker;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDateForwardUnlessNegativeHandler
implements HolidayHandler<LocalDate> {
    public LocalDate moveCurrentDate(BaseCalculator<LocalDate> calculator) {
        return this.adjustDate((LocalDate)calculator.getCurrentBusinessDate(), calculator.getCurrentIncrement(), (NonWorkingDayChecker<LocalDate>)calculator);
    }

    public LocalDate adjustDate(LocalDate startDate, int increment, NonWorkingDayChecker<LocalDate> checker) {
        LocalDate date = startDate;
        while (checker.isNonWorkingDay((Object)date)) {
            if (increment < 0) {
                date = date.minusDays(1);
                continue;
            }
            date = date.plusDays(1);
        }
        return date;
    }

    public String getType() {
        return "forwardUnlessMovingBack";
    }
}

