/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Mocker {


    @NotNull
    public static <T> T logging(@NotNull Class<T> tClass, String description, @NotNull PrintStream out) {
        return Mocker.intercepting(tClass, description, out::println);
    }

    @NotNull
    public static <T> T logging(@NotNull Class<T> tClass, String description, @NotNull PrintWriter out) {
        return Mocker.intercepting(tClass, description, out::println);
    }

    @NotNull
    public static <T> T logging(@NotNull Class<T> tClass, String description, @NotNull StringWriter out) {
        return Mocker.logging(tClass, description, new PrintWriter(out));
    }

    @NotNull
    public static <T> T queuing(@NotNull Class<T> tClass, String description, @NotNull BlockingQueue<String> queue) {
        return Mocker.intercepting(tClass, description, queue::add);
    }

    @NotNull
    public static <T> T intercepting(@NotNull Class<T> tClass, final String description, final @NotNull Consumer<String> consumer) {
        return (T)Proxy.newProxyInstance(tClass.getClassLoader(), new Class[]{tClass}, new InvocationHandler(){

            @Override
            @Nullable
            public Object invoke(Object proxy, @NotNull Method method, @Nullable Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                consumer.accept(description + method.getName() + (args == null ? "()" : Arrays.toString(args)));
                return null;
            }
        });
    }

    @NotNull
    public static <T> T ignored(@NotNull Class<T> tClass) {
        return (T)Proxy.newProxyInstance(tClass.getClassLoader(), new Class[]{tClass}, new InvocationHandler(){

            @Override
            @Nullable
            public Object invoke(Object proxy, @NotNull Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                return null;
            }
        });
    }
}

