/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core;

import com.gitee.fastmybatis.core.EntityProcessor;
import com.gitee.fastmybatis.core.PageResult;
import com.gitee.fastmybatis.core.util.MyBeanUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PageSupport<E>
implements PageResult<E> {
    private static final long serialVersionUID = 5931004082164727399L;
    private List<E> list;
    private long total = 0L;
    private int start = 0;
    private int pageIndex = 1;
    private int pageSize = 10;
    private int pageCount = 0;

    public PageResult process(EntityProcessor<E> processor) {
        if (processor == null) {
            throw new IllegalArgumentException("processor\u4e0d\u80fd\u4e3anull");
        }
        PageSupport pageResult = this;
        List<Object> jsonObjList = PageSupport.processEntityToJSONObject(this.list, processor);
        pageResult.setList(jsonObjList);
        return pageResult;
    }

    public static <E> List<Object> processEntityToJSONObject(List<E> list, EntityProcessor<E> processor) {
        ArrayList<Object> jsonObjList = new ArrayList<Object>(list.size());
        for (E entity : list) {
            Map<String, Object> jsonObject = MyBeanUtil.pojoToMap(entity);
            processor.process(entity, jsonObject);
            jsonObjList.add(jsonObject);
        }
        return jsonObjList;
    }

    public int fatchCurrentPageIndex() {
        return this.pageIndex;
    }

    public int fatchPrePageIndex() {
        return this.pageIndex - 1 <= 0 ? 1 : this.pageIndex - 1;
    }

    public int fatchNextPageIndex() {
        return this.pageIndex + 1 > this.pageCount ? this.pageCount : this.pageIndex + 1;
    }

    public int fatchFirstPageIndex() {
        return 1;
    }

    public int fatchLastPageIndex() {
        return this.pageCount;
    }

    public List<E> fatchList() {
        return this.list;
    }

    public long fatchTotal() {
        return this.total;
    }

    public int fatchPageIndex() {
        return this.pageIndex;
    }

    public int fatchPageSize() {
        return this.pageSize;
    }

    public int fatchStart() {
        return this.start;
    }

    public int fatchPageCount() {
        return this.pageCount;
    }

    @Override
    public void setTotal(long total) {
        this.total = total;
    }

    @Override
    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public void setList(List<E> list) {
        this.list = list;
    }
}

