/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class ClassScanner {
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private List<String> packagesList = new LinkedList<String>();
    private List<TypeFilter> typeIncludes = new LinkedList<TypeFilter>();
    private Set<Class<?>> classSet = new HashSet();

    public ClassScanner(String[] entityPackage, Class<?> scanClass) {
        for (String packagePath : entityPackage) {
            this.packagesList.add(packagePath);
        }
        if (scanClass.isAnnotation()) {
            this.typeIncludes.add((TypeFilter)new AnnotationTypeFilter(scanClass, false));
        } else {
            this.typeIncludes.add((TypeFilter)new AssignableTypeFilter(scanClass));
        }
    }

    public Set<Class<?>> getClassSet() throws IOException, ClassNotFoundException {
        this.classSet.clear();
        if (!this.packagesList.isEmpty()) {
            for (String pkg : this.packagesList) {
                String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + RESOURCE_PATTERN;
                Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                for (Resource resource : resources) {
                    MetadataReader reader;
                    if (!resource.isReadable() || !this.matchesEntityTypeFilter(reader = readerFactory.getMetadataReader(resource), (MetadataReaderFactory)readerFactory)) continue;
                    String className = reader.getClassMetadata().getClassName();
                    this.classSet.add(Class.forName(className));
                }
            }
        }
        return this.classSet;
    }

    private boolean matchesEntityTypeFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        if (!this.typeIncludes.isEmpty()) {
            for (TypeFilter filter : this.typeIncludes) {
                if (!filter.match(reader, readerFactory)) continue;
                return true;
            }
        }
        return false;
    }
}

