/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.ext.SqlSessionFactoryBeanExt;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.xml.sax.EntityResolver;

public class HotDeploy {
    private static final Log LOG = LogFactory.getLog(HotDeploy.class);
    private SqlSessionFactoryBeanExt sqlSessionFactoryBeanExt;
    private FastmybatisConfig fastmybatisConfig;
    private Configuration configuration;

    public HotDeploy(SqlSessionFactoryBeanExt sqlSessionFactoryBeanExt) {
        this.sqlSessionFactoryBeanExt = sqlSessionFactoryBeanExt;
        SqlSessionFactory sqlSessionFactory = sqlSessionFactoryBeanExt.getSqlSessionFactory();
        this.configuration = sqlSessionFactory.getConfiguration();
        this.fastmybatisConfig = sqlSessionFactoryBeanExt.getConfig();
    }

    public void start() {
        if (!this.fastmybatisConfig.isHotDeploy()) {
            return;
        }
        LOG.info((Object)"\u542f\u52a8mapper\u6587\u4ef6\u70ed\u90e8\u7f72\uff0c\u4fee\u6539mapper\u4e0d\u7528\u91cd\u542f\u3002");
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    WatchKey watchKey;
                    boolean valid;
                    Resource[] mapperLocations = HotDeploy.this.sqlSessionFactoryBeanExt.getMapperLocations();
                    if (mapperLocations == null) {
                        LOG.warn((Object)"mapperLocations\u4e3anull\uff0c\u786e\u4fdd\u662f\u5426\u6709mybatis\u7684xml\u6587\u4ef6");
                        return;
                    }
                    WatchService watcher = FileSystems.getDefault().newWatchService();
                    Set<String> watchPaths = HotDeploy.this.getWatchPaths(mapperLocations);
                    for (String watchPath : watchPaths) {
                        Paths.get(watchPath, new String[0]).register(watcher, StandardWatchEventKinds.ENTRY_MODIFY);
                    }
                    do {
                        watchKey = watcher.take();
                        HashSet<String> set = new HashSet<String>();
                        for (WatchEvent<?> event : watchKey.pollEvents()) {
                            set.add(event.context().toString());
                        }
                        LOG.debug((Object)("\u4fee\u6539\u4e86xml\u6587\u4ef6\uff0c\u91cd\u65b0\u52a0\u8f7dmapper\u3002files:" + set));
                        HotDeploy.this.reloadXml(mapperLocations);
                    } while (valid = watchKey.reset());
                }
                catch (Exception e) {
                    LOG.error((Object)"mapper\u70ed\u90e8\u7f72\u5931\u8d25", (Throwable)e);
                }
            }
        });
    }

    protected void reloadXml(Resource[] mapperLocations) throws IOException {
        Resource[] finalMapperLocations;
        Resource[] mapperLocationsNew = new Resource[mapperLocations.length];
        for (int i = 0; i < mapperLocations.length; ++i) {
            Resource resource;
            Resource mapperLocation = mapperLocations[i];
            String path = mapperLocation.getURL().getPath();
            mapperLocationsNew[i] = resource = this.getResource(path);
        }
        for (Resource resource : finalMapperLocations = this.sqlSessionFactoryBeanExt.getFinalMapperLocations()) {
            this.clearMap(this.getNamespace(resource));
            this.clearSet(resource.toString());
        }
        this.sqlSessionFactoryBeanExt.setMapperLocations(mapperLocationsNew);
        this.sqlSessionFactoryBeanExt.buildSqlSessionFactory();
    }

    protected Set<String> getWatchPaths(Resource[] mapperLocations) throws IOException {
        HashSet<String> set = new HashSet<String>();
        for (Resource resource : mapperLocations) {
            set.add(resource.getFile().getParentFile().getAbsolutePath());
        }
        return set;
    }

    protected Resource getResource(String path) {
        return new FileSystemResource(path);
    }

    private void clearMap(String nameSpace) {
        List<String> stringList = Arrays.asList("mappedStatements", "caches", "resultMaps", "parameterMaps", "keyGenerators", "sqlFragments");
        for (String fieldName : stringList) {
            Object value = this.getFieldValue(this.configuration, fieldName);
            if (!(value instanceof Map)) continue;
            Map map = (Map)value;
            List<Object> list = this.getList(map.keySet(), nameSpace);
            for (Object k : list) {
                map.remove(k);
            }
        }
    }

    private List<Object> getList(Set<?> sets, String nameSpace) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object o : sets) {
            if (!o.toString().startsWith(nameSpace + ".")) continue;
            ret.add(o);
        }
        return ret;
    }

    private void clearSet(String resource) {
        Object value = this.getFieldValue(this.configuration, "loadedResources");
        if (value instanceof Set) {
            Set set = (Set)value;
            set.remove(resource);
            set.remove("namespace:" + resource);
        }
    }

    private Object getFieldValue(Object obj, String fieldName) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            Object value = field.get(obj);
            field.setAccessible(accessible);
            return value;
        }
        catch (Exception e) {
            LOG.info((Object)("ERROR: \u52a0\u8f7d\u5bf9\u8c61\u4e2d[" + fieldName + "]"), (Throwable)e);
            return null;
        }
    }

    private String getNamespace(Resource resource) {
        try {
            XPathParser parser = new XPathParser(resource.getInputStream(), true, null, (EntityResolver)new XMLMapperEntityResolver());
            return parser.evalNode("/mapper").getStringAttribute("namespace");
        }
        catch (Exception e) {
            LOG.info((Object)"ERROR: \u89e3\u6790xml\u4e2dnamespace\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

